/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import java.util.HashSet;
import java.util.Set;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.Node;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.IDESourcePosition;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;

public class AccidentalBooleanAssignmentVisitor
extends RubyLintVisitor {
    private Set<String> locals = new HashSet<String>();

    public AccidentalBooleanAssignmentVisitor(String contents) {
        super(AptanaRDTPlugin.getDefault().getOptions(), contents);
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.possibleAccidentalBooleanAssignment";
    }

    public Instruction visitLocalAsgnNode(LocalAsgnNode iVisited) {
        this.locals.add(iVisited.getName());
        return super.visitLocalAsgnNode(iVisited);
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        this.locals.clear();
        return super.visitDefnNode(iVisited);
    }

    public Instruction visitDefsNode(DefsNode iVisited) {
        this.locals.clear();
        return super.visitDefsNode(iVisited);
    }

    public Instruction visitIfNode(IfNode iVisited) {
        Node condition = iVisited.getCondition();
        if (this.containsAssignment(condition)) {
            LocalAsgnNode assign;
            if (condition instanceof LocalAsgnNode && !this.locals.contains((assign = (LocalAsgnNode)condition).getName())) {
                return super.visitIfNode(iVisited);
            }
            ISourcePosition original = condition.getPosition();
            IDESourcePosition position = new IDESourcePosition(original.getFile(), original.getStartLine(), original.getEndLine(), original.getStartOffset(), original.getEndOffset() - 1);
            this.createProblem((ISourcePosition)position, "Possible accidental boolean assignment");
        }
        return super.visitIfNode(iVisited);
    }

    private boolean containsAssignment(Node condition) {
        return condition instanceof LocalAsgnNode || condition instanceof GlobalAsgnNode || condition instanceof InstAsgnNode || condition instanceof ClassVarAsgnNode;
    }

    protected int getProblemID() {
        return 135;
    }
}

