/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import java.util.Map;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;

public class TooManyLinesVisitor
extends RubyLintVisitor {
    public static final int DEFAULT_MAX_LINES = 20;
    private int maxLines = this.getInt("com.aptana.rdt.compiler.problem.maxLines", 20);

    public TooManyLinesVisitor(String contents) {
        this(AptanaRDTPlugin.getDefault().getOptions(), contents);
    }

    public TooManyLinesVisitor(Map options, String contents) {
        super(options, contents);
    }

    private int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt((String)this.fOptions.get(key));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.codeComplexityLines";
    }

    public Instruction visitDefsNode(DefsNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        int lines = pos.getEndLine() - pos.getStartLine() - 1;
        if (lines > this.maxLines) {
            this.createProblem(iVisited.getNameNode().getPosition(), "Too many lines in method: " + lines);
        }
        return super.visitDefsNode(iVisited);
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        int lines = pos.getEndLine() - pos.getStartLine() - 1;
        if (lines > this.maxLines) {
            this.createProblem(iVisited.getNameNode().getPosition(), "Too many lines in method: " + lines);
        }
        return super.visitDefnNode(iVisited);
    }
}

