/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.ui.actions;

import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.core.gems.IGemManager;
import com.aptana.rdt.ui.gems.GemsMessages;
import com.aptana.rdt.ui.gems.GemsView;
import com.aptana.rdt.ui.gems.RemoveGemDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class RemoveGemActionDelegate
implements IObjectActionDelegate,
IViewActionDelegate {
    private GemsView view;
    private Gem selectedGem;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.selectedGem == null) {
            return;
        }
        boolean okay = MessageDialog.openConfirm((Shell)this.view.getViewSite().getShell(), null, (String)GemsMessages.bind((String)GemsMessages.RemoveGemDialog_msg, (Object)this.selectedGem.getName()));
        if (!okay) {
            return;
        }
        Job job = null;
        if (this.selectedGem.hasMultipleVersions()) {
            final int[] result = new int[1];
            final String[] version = new String[1];
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    RemoveGemDialog dialog = new RemoveGemDialog(Display.getDefault().getActiveShell(), RemoveGemActionDelegate.this.selectedGem.versions());
                    result[0] = dialog.open();
                    version[0] = dialog.getVersion();
                }
            });
            if (result[0] != 0) {
                return;
            }
            job = new Job("Removing gem..."){

                protected IStatus run(IProgressMonitor monitor) {
                    return RemoveGemActionDelegate.this.getGemManager().removeGem(new Gem(RemoveGemActionDelegate.this.selectedGem.getName(), version[0], RemoveGemActionDelegate.this.selectedGem.getDescription()), monitor);
                }
            };
        } else {
            job = new Job("Removing gem..."){

                protected IStatus run(IProgressMonitor monitor) {
                    return RemoveGemActionDelegate.this.getGemManager().removeGem(RemoveGemActionDelegate.this.selectedGem, monitor);
                }
            };
        }
        if (job != null) {
            job.setUser(true);
            job.schedule();
        }
    }

    protected IGemManager getGemManager() {
        return this.view.getGemManager();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            action.setEnabled(false);
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        Object element = sel.getFirstElement();
        if (!(element instanceof Gem)) {
            action.setEnabled(false);
            return;
        }
        this.selectedGem = (Gem)element;
        action.setEnabled(true);
    }

    public void init(IViewPart view) {
        this.view = (GemsView)view;
    }
}

