/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.ui.rspec;

import com.aptana.rdt.core.rspec.Behavior;
import com.aptana.rdt.core.rspec.Example;
import com.aptana.rdt.core.rspec.RSpecStructureCreator;
import com.aptana.rdt.ui.AptanaRDTUIPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.rubypeople.rdt.core.IImportContainer;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.ASTProvider;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyOutlinePage;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyElementImageProvider;
import org.rubypeople.rdt.ui.RubyElementLabels;
import org.rubypeople.rdt.ui.rubyeditor.ICustomRubyOutlinePage;
import org.rubypeople.rdt.ui.viewsupport.ImageDescriptorRegistry;

public class RSpecOutlinePage
extends RubyOutlinePage
implements ICustomRubyOutlinePage {
    protected ITreeContentProvider getContentProvider() {
        return new RSpecChildrenProvider();
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Example) {
                    return ((Example)element).getDescription();
                }
                if (element instanceof Behavior) {
                    return ((Behavior)element).getClassName();
                }
                if (element instanceof IRubyElement) {
                    return RubyElementLabels.getTextLabel((Object)element, (long)0L);
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                ImageDescriptorRegistry registry = RubyPlugin.getImageDescriptorRegistry();
                ImageDescriptor descriptor = null;
                if (element instanceof Example) {
                    descriptor = RubyElementImageProvider.getMethodImageDescriptor((int)0);
                } else if (element instanceof Behavior) {
                    descriptor = RubyElementImageProvider.getTypeImageDescriptor((boolean)false, (boolean)false, (boolean)false);
                } else if (element instanceof IRubyElement) {
                    descriptor = new RubyElementImageProvider().getRubyImageDescriptor((IRubyElement)element, 0);
                }
                if (descriptor != null) {
                    return registry.get(descriptor);
                }
                return super.getImage(element);
            }
        };
    }

    public boolean isEnabled(IRubyElement inputElement) {
        if (inputElement == null) {
            return false;
        }
        IPath path = inputElement.getPath();
        if (path == null) {
            return false;
        }
        String name = path.lastSegment();
        return name.endsWith("_spec.rb");
    }

    class RSpecChildrenProvider
    extends RubyOutlinePage.ChildrenProvider {
        RSpecChildrenProvider() {
            super((RubyOutlinePage)RSpecOutlinePage.this);
        }

        public Object[] getElements(Object inputElement) {
            IRubyScript script = (IRubyScript)inputElement;
            RootNode root = ASTProvider.getASTProvider().getAST((IRubyElement)script, ASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
            RSpecStructureCreator rspecCreator = new RSpecStructureCreator();
            rspecCreator.acceptNode((Node)root);
            Object[] behaviors = rspecCreator.getBehaviors();
            Object[] all = new Object[behaviors.length + 1];
            all[0] = script.getImportContainer();
            System.arraycopy(behaviors, 0, all, 1, behaviors.length);
            return all;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IRubyScript) {
                return true;
            }
            if (element instanceof Behavior) {
                return true;
            }
            if (element instanceof Example) {
                return false;
            }
            return element instanceof IImportContainer;
        }

        public Object getParent(Object element) {
            if (element instanceof IRubyScript) {
                return null;
            }
            if (element instanceof Example) {
                return ((Example)element).getBehavior();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Behavior) {
                return ((Behavior)parentElement).getExamples();
            }
            try {
                if (parentElement instanceof IParent) {
                    return ((IParent)parentElement).getChildren();
                }
            }
            catch (RubyModelException e) {
                AptanaRDTUIPlugin.log(e);
            }
            return new Object[0];
        }
    }
}

