/*
 * Decompiled with CFR 0.152.
 */
package net.lucky_dip.sasseditor.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class SassIndentLineAutoEditStrategy
implements IAutoEditStrategy {
    public static final String INDENT_STRING = "  ";

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.length == 0 && c.text != null && TextUtilities.endsWith((String[])d.getLegalLineDelimiters(), (String)c.text) != -1) {
            this.autoIndentAfterNewLine(d, c);
        } else if (c.text.equals("\t")) {
            c.text = INDENT_STRING;
        }
    }

    private void autoIndentAfterNewLine(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            String lastPartitionType = null;
            if (d instanceof IDocumentExtension3) {
                IDocumentExtension3 id3 = (IDocumentExtension3)d;
                lastPartitionType = id3.getDocumentPartitioner("__sass_partitioning").getContentType(c.offset - 1);
            }
            int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            IRegion info = d.getLineInformationOfOffset(p);
            int start = info.getOffset();
            int end = this.findEndOfWhiteSpace(d, start, c.offset);
            StringBuffer buf = new StringBuffer(c.text);
            if (lastPartitionType != null && (lastPartitionType.equalsIgnoreCase("__sass_class") || lastPartitionType.equalsIgnoreCase("__sass_id"))) {
                buf.append(INDENT_STRING);
            }
            if (end > start) {
                buf.append(d.get(start, end - start));
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    protected int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }
}

