/*
 * Decompiled with CFR 0.152.
 */
package net.lucky_dip.sasseditor.editor.scanners;

import java.util.ArrayList;
import net.lucky_dip.sasseditor.editor.SassWordDetector;
import net.lucky_dip.sasseditor.editor.rules.SassAttributeRule;
import net.lucky_dip.sasseditor.editor.rules.SassTagRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordPatternRule;

public class SassPartitionScanner
extends RuleBasedPartitionScanner {
    private static SassPartitionScanner instance;
    public static final String SASS_CONSTANT = "__sass_constant";
    public static final String SASS_ATTRIBUTE = "__sass_attribute";
    public static final String SASS_CLASS = "__sass_class";
    public static final String SASS_ID = "__sass_id";
    public static final String SASS_TAG = "__sass_tag";
    public static final String[] SASS_PARTITION_TYPES;

    static {
        SASS_PARTITION_TYPES = new String[]{SASS_CONSTANT, SASS_ATTRIBUTE, SASS_CLASS, SASS_ID, SASS_TAG};
    }

    public static boolean IsSassPartitionType(String contentType) {
        boolean res = false;
        int i = 0;
        while (!res && i < SASS_PARTITION_TYPES.length) {
            res = contentType.equals(SASS_PARTITION_TYPES[i]);
            ++i;
        }
        return res;
    }

    public static SassPartitionScanner getInstance() {
        if (instance == null) {
            instance = new SassPartitionScanner();
        }
        return instance;
    }

    private SassPartitionScanner() {
        Token constantToken = new Token((Object)SASS_CONSTANT);
        Token attributeToken = new Token((Object)SASS_ATTRIBUTE);
        Token classToken = new Token((Object)SASS_CLASS);
        Token idToken = new Token((Object)SASS_ID);
        Token tagToken = new Token((Object)SASS_TAG);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WordPatternRule((IWordDetector)new SassWordDetector(), "#", "", (IToken)classToken));
        rules.add(new WordPatternRule((IWordDetector)new SassWordDetector(), "!", "", (IToken)constantToken));
        rules.add(new WordPatternRule((IWordDetector)new SassWordDetector(), ".", "", (IToken)idToken));
        rules.add(new WordPatternRule((IWordDetector)new SassWordDetector(), ":", "", (IToken)attributeToken));
        rules.add(new SassAttributeRule((IToken)attributeToken));
        rules.add(new SassTagRule((IToken)tagToken));
        IPredicateRule[] result = new IPredicateRule[rules.size()];
        rules.toArray(result);
        this.setPredicateRules(result);
    }
}

