/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.rake;

import com.aptana.rdt.internal.rake.Namespace;
import com.aptana.rdt.internal.rake.Task;
import java.util.ArrayList;
import java.util.List;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.StrNode;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.internal.core.parser.InOrderVisitor;
import org.rubypeople.rdt.internal.core.util.ASTUtil;

public class RakeStructureCreator
extends InOrderVisitor {
    private static final String TASK = "task";
    private static final String NAMESPACE = "namespace";
    private List<Namespace> namespaces = new ArrayList<Namespace>();

    public Instruction visitFCallNode(FCallNode visited) {
        if (visited.getName().equals(TASK)) {
            String name = this.getFirstArgument((IArgumentNode)visited);
            Task task = new Task(name, this.getStart((Node)visited), this.getLength((Node)visited));
            Namespace curNamespace = this.namespaces.get(this.namespaces.size() - 1);
            curNamespace.addChild(task);
        } else if (visited.getName().equals(NAMESPACE)) {
            String namespaceName = this.getFirstArgument((IArgumentNode)visited);
            Namespace namespace = new Namespace(namespaceName, this.getStart((Node)visited), this.getLength((Node)visited));
            Namespace curNamespace = this.namespaces.get(this.namespaces.size() - 1);
            curNamespace.addChild(namespace);
            this.namespaces.add(namespace);
            Instruction ins = super.visitFCallNode(visited);
            this.namespaces.remove(this.namespaces.size() - 1);
            return ins;
        }
        return super.visitFCallNode(visited);
    }

    public Instruction visitCallNode(CallNode visited) {
        String receiver;
        if (visited.getName().equals("new") && ((receiver = ASTUtil.stringRepresentation((Node)visited.getReceiverNode())).equals("TestTask") || receiver.equals("RDocTask"))) {
            String name = this.getFirstArgument((IArgumentNode)visited);
            Task task = new Task(name, this.getStart((Node)visited), this.getLength((Node)visited));
            Namespace curNamespace = this.namespaces.get(this.namespaces.size() - 1);
            curNamespace.addChild(task);
        }
        return super.visitCallNode(visited);
    }

    private String getFirstArgument(IArgumentNode visited) {
        List args = ASTUtil.getArgumentsFromFunctionCall((IArgumentNode)visited);
        Node arguments = visited.getArgsNode();
        String name = (String)args.get(0);
        if (arguments instanceof ArrayNode) {
            ArrayNode array = (ArrayNode)arguments;
            Node firstArg = array.get(0);
            if (firstArg instanceof HashNode) {
                HashNode hash = (HashNode)firstArg;
                Node firstHashMember = hash.getListNode().get(0);
                name = ASTUtil.getNameReflectively((Node)firstHashMember);
            }
            if (firstArg instanceof StrNode) {
                name = ((StrNode)firstArg).getValue().toString();
            } else {
                String newName = ASTUtil.getNameReflectively((Node)firstArg);
                if (newName != null) {
                    name = newName;
                }
            }
        }
        return name;
    }

    public Instruction visitRootNode(RootNode visited) {
        this.namespaces.add(new Namespace("ROOT", this.getStart((Node)visited), this.getLength((Node)visited)));
        return super.visitRootNode(visited);
    }

    private int getLength(Node visited) {
        return this.getEnd(visited) - this.getStart(visited) + 1;
    }

    private int getEnd(Node visited) {
        return visited.getPosition().getEndOffset();
    }

    private int getStart(Node visited) {
        return visited.getPosition().getStartOffset();
    }

    public Object[] getTasks() {
        return this.namespaces.get(this.namespaces.size() - 1).getChildren();
    }
}

