/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.rake.actions;

import com.aptana.rdt.internal.rake.actions.RunRakeAction;
import com.aptana.rdt.rake.IRakeHelper;
import com.aptana.rdt.rake.RakePlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class RakeAction
implements IObjectActionDelegate,
IMenuCreator {
    private static final String RAKE_NAMESPACE_DELIMETER = ":";
    private boolean fFillMenu;
    private IAction fDelegateAction;
    private IStructuredSelection fSelection;
    private HashMap<String, MenuManager> fNamespaces;
    private Menu menu;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fFillMenu = true;
            if (this.fDelegateAction != action) {
                this.fDelegateAction = action;
                this.fDelegateAction.setMenuCreator((IMenuCreator)this);
            }
            this.fSelection = (IStructuredSelection)selection;
            action.setEnabled(true);
            return;
        }
        action.setEnabled(false);
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        this.menu = new Menu(parent);
        this.menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                if (RakeAction.this.fFillMenu) {
                    Menu m = (Menu)e.widget;
                    MenuItem[] items = m.getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].dispose();
                        ++i;
                    }
                    RakeAction.this.fillMenu(m);
                    RakeAction.this.fFillMenu = false;
                }
            }
        });
        return this.menu;
    }

    protected void fillMenu(Menu menu) {
        if (this.fSelection == null) {
            return;
        }
        IResource resource = (IResource)this.fSelection.getFirstElement();
        IProject project = resource.getProject();
        Map<String, String> tasks = this.getRakeHelper().getTasks(project, (IProgressMonitor)new NullProgressMonitor());
        this.fNamespaces = new HashMap();
        ArrayList values = new ArrayList(tasks.keySet());
        Collections.sort(values);
        for (String task : values) {
            String[] paths = task.split(RAKE_NAMESPACE_DELIMETER);
            if (paths.length == 1) {
                RunRakeAction action = new RunRakeAction(project, task, tasks.get(task));
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                item.fill(menu, -1);
                continue;
            }
            MenuManager manager = this.getOrCreate(paths);
            manager.add((IAction)new RunRakeAction(project, task, tasks.get(task)));
        }
        values = new ArrayList(this.fNamespaces.keySet());
        Collections.sort(values);
        Collections.reverse(values);
        for (String path : values) {
            int index;
            MenuManager manager = this.fNamespaces.get(path);
            String[] parts = path.split(RAKE_NAMESPACE_DELIMETER);
            if (parts.length == 1) {
                int index2 = this.getInsertIndex(menu, manager);
                manager.fill(menu, index2);
                continue;
            }
            MenuManager parent = this.getParent(parts);
            if (parent != null) {
                index = this.getInsertIndex(parent, manager);
                parent.insert(index, (IContributionItem)manager);
                continue;
            }
            index = this.getInsertIndex(menu, manager);
            manager.fill(menu, index);
        }
    }

    private int getInsertIndex(MenuManager parent, MenuManager item) {
        if (parent == null || item == null) {
            return 0;
        }
        String text = item.getMenuText();
        if (text == null) {
            return 0;
        }
        IContributionItem[] items = parent.getItems();
        if (items == null) {
            return 0;
        }
        int index = 0;
        int i = 0;
        while (i < items.length) {
            ActionContributionItem actionItem;
            IAction action;
            if (items[i] != null && items[i] instanceof ActionContributionItem && (action = (actionItem = (ActionContributionItem)items[i]).getAction()) != null) {
                String other = action.getText();
                if (text.compareTo(other) < 0) break;
                index = i + 1;
            }
            ++i;
        }
        return index;
    }

    private int getInsertIndex(Menu parent, MenuManager item) {
        String text = item.getMenuText();
        MenuItem[] items = parent.getItems();
        int index = 0;
        int i = 0;
        while (i < items.length) {
            String other = items[i].getText();
            if (text.compareTo(other) < 0) break;
            index = i + 1;
            ++i;
        }
        return index;
    }

    protected IRakeHelper getRakeHelper() {
        return RakePlugin.getDefault().getRakeHelper();
    }

    private MenuManager getParent(String[] parts) {
        String[] part = this.stripLastItem(parts);
        return this.fNamespaces.get(this.join(part));
    }

    private String join(String[] part) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < part.length) {
            if (i != 0) {
                buffer.append(RAKE_NAMESPACE_DELIMETER);
            }
            buffer.append(part[i]);
            ++i;
        }
        return buffer.toString();
    }

    private MenuManager getOrCreate(String[] paths) {
        String[] part = this.stripLastItem(paths);
        MenuManager manager = this.fNamespaces.get(this.join(part));
        if (manager == null) {
            manager = new MenuManager(part[part.length - 1]);
            this.fNamespaces.put(this.join(part), manager);
        }
        return manager;
    }

    private String[] stripLastItem(String[] paths) {
        String[] part = new String[paths.length - 1];
        System.arraycopy(paths, 0, part, 0, part.length);
        return part;
    }
}

