/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc;

import com.ibm.db2.jcc.c.j;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class DB2Binder {
    private static Set traceLevelOptions__;
    j binder_ = new j();
    static /* synthetic */ Class class$com$ibm$db2$jcc$DB2BaseDataSource;

    public static void main(String[] stringArray) throws Exception {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        DB2Binder dB2Binder = new DB2Binder();
        if (stringArray.length == 0) {
            DB2Binder.printUsage(printWriter);
            return;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string;
            if ((string = stringArray[n2++]).equalsIgnoreCase("-help")) {
                DB2Binder.printUsage(printWriter);
                continue;
            }
            if (string.equalsIgnoreCase("-url")) {
                dB2Binder.setUrl(stringArray[n2++]);
                continue;
            }
            if (string.equalsIgnoreCase("-user")) {
                dB2Binder.setUser(stringArray[n2++]);
                continue;
            }
            if (string.equalsIgnoreCase("-password")) {
                dB2Binder.setPassword(stringArray[n2++]);
                continue;
            }
            if (string.equalsIgnoreCase("-action")) {
                dB2Binder.setAction(stringArray[n2++]);
                continue;
            }
            if (string.equalsIgnoreCase("-collection")) {
                dB2Binder.setCollection(stringArray[n2++]);
                continue;
            }
            if (string.equalsIgnoreCase("-dbprotocol")) {
                dB2Binder.setDbProtocol(stringArray[n2++]);
                continue;
            }
            if (string.equalsIgnoreCase("-keepdynamic")) {
                dB2Binder.setKeepDynamic(stringArray[n2++]);
                continue;
            }
            if (string.equalsIgnoreCase("-owner")) {
                dB2Binder.setOwner(stringArray[n2++]);
                continue;
            }
            if (string.equalsIgnoreCase("-reopt")) {
                dB2Binder.setReopt(stringArray[n2++]);
                continue;
            }
            if (string.equalsIgnoreCase("-size")) {
                dB2Binder.setSize(Integer.parseInt(stringArray[n2++]));
                continue;
            }
            if (string.equalsIgnoreCase("-tracelevel")) {
                try {
                    dB2Binder.setTraceLevel(DB2Binder.parseTraceLevel(stringArray[n2++]));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    printWriter.println(illegalArgumentException.getMessage());
                    DB2Binder.printUsage(printWriter);
                    return;
                }
            }
            printWriter.println("Unrecognized option " + string);
            DB2Binder.printUsage(printWriter);
            return;
        }
        try {
            Class.forName("com.ibm.db2.jcc.DB2Driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            printWriter.println("Failure loading JDBC driver com.ibm.db2.jcc.DB2Driver.");
            printWriter.println("ClassNotFoundException: " + classNotFoundException.getMessage());
            return;
        }
        dB2Binder.binderMain(printWriter);
    }

    public void binderMain(PrintWriter printWriter) {
        this.binder_.a(printWriter);
    }

    private void setUrl(String string) {
        this.binder_.a(string);
    }

    private void setUser(String string) {
        this.binder_.b(string);
    }

    private void setPassword(String string) {
        this.binder_.c(string);
    }

    private void setAction(String string) {
        this.binder_.d(string);
    }

    private void setCollection(String string) {
        this.binder_.e(string);
    }

    private void setDbProtocol(String string) {
        this.binder_.f(string);
    }

    private void setKeepDynamic(String string) {
        this.binder_.g(string);
    }

    private void setOwner(String string) {
        this.binder_.h(string);
    }

    private void setReopt(String string) {
        this.binder_.i(string);
    }

    private void setSize(int n2) {
        this.binder_.a(n2);
    }

    private void setTraceLevel(int n2) {
        this.binder_.b(n2);
    }

    private static void printUsage(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println();
        printWriter.println("IBM DB2 JDBC Universal Driver Architecture, JDBC Package Binder");
        printWriter.println("(c) Copyright IBM Corporation 2002");
        printWriter.println();
        printWriter.println("This binder utility is used to add the standard JCC JDBC packageset to the target database URL.");
        printWriter.println("The latest version of the JCC JDBC packageset will be bound to the server.");
        printWriter.println();
        printWriter.println("Usage:");
        printWriter.println();
        printWriter.println("  java com.ibm.db2.jcc.DB2Binder");
        printWriter.println("    -url jdbc:db2://<server name>:<port number>/<database name>");
        printWriter.println("    -user <userName>");
        printWriter.println("    -password <password>");
        printWriter.println("    [-action { add | replace }]");
        printWriter.println("    [-collection <collection to bind the JCC packages, default is NULLID>]");
        printWriter.println("    [-dbprotocol { drda | private }]");
        printWriter.println("    [-help]");
        printWriter.println("    [-keepdynamic { no | yes }]");
        printWriter.println("    [-owner <owner of the JCC packages>]");
        printWriter.println("    [-reopt once]");
        printWriter.println("    [-size <number of dynamic JCC packages bound for each isolation and holdability>]");
        printWriter.println("    [-tracelevel <comma-delimited list of jcc trace options>]");
        printWriter.println();
        printWriter.println("  -user");
        printWriter.println("    The user must have bind authority.");
        printWriter.println("    Access to the JCC packages will be granted to public.");
        printWriter.println();
        printWriter.println("  -action");
        printWriter.println("    Indicates whether the packages can be added or replaced.");
        printWriter.println("    The default is \"add\".");
        printWriter.println("    \"add\" indicates that a new package to be created only if it does not exist already.");
        printWriter.println("    \"replace\" indicates that a new package is created to replace any existing package.");
        printWriter.println();
        printWriter.println("  -collection");
        printWriter.println("    The collection ID for JCC's internal packages for JDBC.");
        printWriter.println("    The default is NULLID.");
        printWriter.println("    May be used by DBA's to create multiple instances of the JCC package set.");
        printWriter.println("    This option may only be used in conjunction with the connection/datasource property jdbcCollection.");
        printWriter.println("    Also see documentation for JCC DB2BaseDataSource.jdbcCollection.");
        printWriter.println();
        printWriter.println("  -dbprotocol");
        printWriter.println("    Specifies which protocol to use when connecting to a remote site that is identified");
        printWriter.println("    by a three-part name statement.");
        printWriter.println("    Supported by DB2 for OS/390 only.");
        printWriter.println("    The default is \"drda\" for OS/390.");
        printWriter.println("    \"drda\" indicates that DRDA protocol will be used.");
        printWriter.println("    \"private\" indicates that DB2 private protocol will be used.");
        printWriter.println();
        printWriter.println("  -keepdynamic");
        printWriter.println("    Determines whether DB2 keeps dynamic SQL statements after commit points.");
        printWriter.println("    Supported by DB2 for OS/390 only.");
        printWriter.println("    This option is not sent if not specified. Thus, the default depends on server.");
        printWriter.println("    \"no\" specifies that DB2 does not keep dynamic SQL statements after commit points.");
        printWriter.println("    \"yes\" specifies that DB2 keeps dynamic SQL statements after commit points.");
        printWriter.println();
        printWriter.println("  -owner");
        printWriter.println("    Designates an authorization identifier as the owner of the JCC packages.");
        printWriter.println("    This option is not sent if not specified. Thus, the default depends on server.");
        printWriter.println();
        printWriter.println("  -reopt once");
        printWriter.println("    Specifies whether to have DB2 determine an access path at run time only once, ");
        printWriter.println("    and use that access path afterwards.");
        printWriter.println("    Supported by DB2 for OS/390 only.");
        printWriter.println("    This option is not sent if not specified. Thus, the default depends on server.");
        printWriter.println();
        printWriter.println("  -size");
        printWriter.println("    The number of internal JCC packages to bind for each DB2 isolation and holdability.");
        printWriter.println("    The default is 3.");
        printWriter.println("    Since there are 4 DB2 transaction isolations and 2 cursor holdabilities,");
        printWriter.println("    there will be 4x2=8 times as many dynamic packages bound as are specified by this option.");
        printWriter.println("    In addition, a single static package for JCC's internal use is always bound.");
        printWriter.println();
        printWriter.println("  -tracelevel");
        printWriter.println("    Used to turn tracing on or off, and to specify the granularity of tracing.");
        printWriter.println("    Trace level options are defined by the JCC JDBC driver traceLevel data source property.");
        printWriter.println("    See documentation for JCC DB2BaseDataSource.traceLevel for a complete description.");
        printWriter.println("    For complete tracing, use TRACE_ALL.  Not all of the JCC JDBC trace level options");
        printWriter.println("    are meaningful for DB2Binder, but the complete options are: ");
        if (traceLevelOptions__ == null) {
            DB2Binder.reflectTraceLevelOptions();
        }
        Iterator iterator = traceLevelOptions__.iterator();
        printWriter.print(iterator.next());
        while (iterator.hasNext()) {
            printWriter.print("," + iterator.next());
        }
        printWriter.println();
        printWriter.println();
        printWriter.println("Note: There is currently only one version of the JCC JDBC packageset.");
        printWriter.println("      So the current syntax does not allow for adding or dropping specific versions");
        printWriter.println("      of the JCC JDBC packageset.  This syntax could be extended at a later date to support this");
        printWriter.println("      if and when the contents of the JCC JDBC packageset definition changes.");
        printWriter.println();
        printWriter.println();
    }

    private static void reflectTraceLevelOptions() {
        traceLevelOptions__ = new TreeSet();
        Class clazz = class$com$ibm$db2$jcc$DB2BaseDataSource == null ? (class$com$ibm$db2$jcc$DB2BaseDataSource = DB2Binder.class$("com.ibm.db2.jcc.DB2BaseDataSource")) : class$com$ibm$db2$jcc$DB2BaseDataSource;
        Field[] fieldArray = clazz.getFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            String string = fieldArray[n2].getName();
            if (string.startsWith("TRACE_")) {
                traceLevelOptions__.add(string);
            }
            ++n2;
        }
    }

    public static int parseTraceLevel(String string) throws IllegalArgumentException {
        String string2 = string.toUpperCase();
        if (traceLevelOptions__ == null) {
            DB2Binder.reflectTraceLevelOptions();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String string3 = null;
        int n2 = 0;
        while (stringTokenizer.hasMoreElements()) {
            string3 = (String)stringTokenizer.nextElement();
            if (traceLevelOptions__.contains(string3)) {
                Class clazz = class$com$ibm$db2$jcc$DB2BaseDataSource == null ? DB2Binder.class$("com.ibm.db2.jcc.DB2BaseDataSource") : class$com$ibm$db2$jcc$DB2BaseDataSource;
                try {
                    Field field = clazz.getDeclaredField(string3);
                    n2 |= field.getInt(null);
                    continue;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new IllegalArgumentException("bug check: NoSuchFieldException shouldn't happen");
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalArgumentException("bug check: IllegalAccessException shouldn't happen");
                }
            }
            throw new IllegalArgumentException("Unsupported tracelevel: " + string3);
        }
        return n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

