/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc;

import com.ibm.db2.jcc.DB2BaseDataSource;
import com.ibm.db2.jcc.DB2ConnectionPoolDataSource;
import com.ibm.db2.jcc.a.b;
import com.ibm.db2.jcc.a.g;
import com.ibm.db2.jcc.c.SqlException;
import com.ibm.db2.jcc.c.mc;
import com.ibm.db2.jcc.c.n;
import com.ibm.db2.jcc.c.xb;
import com.ibm.db2.jcc.t2.T2Configuration;
import com.ibm.db2.jcc.t2zos.T2zosConnection;
import com.ibm.db2.jcc.uw.UWConnection;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.Referenceable;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class DB2DataSource
extends DB2BaseDataSource
implements DataSource,
Serializable,
Referenceable {
    private static final long serialVersionUID = 6447560170638224643L;
    static final String className__ = "com.ibm.db2.jcc.DB2DataSource";
    private String password = null;
    public static final String propertyKey_password = "password";
    private transient mc pool_;
    private DB2ConnectionPoolDataSource cpds_ = new DB2ConnectionPoolDataSource();
    private boolean isConnectionPoolDataSourceSet = false;

    public synchronized void setPassword(String string) {
        this.password = string;
    }

    public void finalize() throws SQLException {
        if (this.pool_ != null) {
            this.pool_.a();
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        PooledConnection pooledConnection;
        if (this.driverType == 4 && (n.qb || n.tb)) {
            throw new SqlException(null, "Type-4 connectivity not supported under CICS or IMS environments. Use Type-2 connectivity only.");
        }
        if (this.driverType == 2 && T2Configuration.a() == 1) {
            return this.getSimpleConnection(this.user, this.password);
        }
        Object var3_3 = null;
        if (string != null) {
            this.user = string;
        }
        if (string2 != null) {
            this.password = string2;
        }
        this.initialize();
        if (this.cpds_ == null) {
            return this.getSimpleConnection(this.user, this.password);
        }
        if (this.pool_ == null) {
            this.pool_ = new mc();
        }
        if ((pooledConnection = this.pool_.a(string, string2)) == null) {
            DB2ConnectionPoolDataSource dB2ConnectionPoolDataSource = this.cpds_;
            synchronized (dB2ConnectionPoolDataSource) {
                pooledConnection = this.cpds_.getPooledConnection(string, string2);
            }
            pooledConnection.addConnectionEventListener(this.pool_);
        }
        return pooledConnection.getConnection();
    }

    public Connection getSimpleConnection(String string, String string2) throws SQLException {
        xb xb2 = super.computeJccLogWriterForNewConnection("_ds");
        switch (this.driverType) {
            case 4: {
                if (n.qb || n.tb) {
                    throw new SqlException(null, "Type-4 connectivity not supported under CICS or IMS environments. Use Type-2 connectivity only.");
                }
                return new b((g)xb2, string, string2, this, -1, false);
            }
            case 2: {
                short s2 = T2Configuration.a();
                if (2 == s2) {
                    return new UWConnection((g)xb2, string, string2, this, 0, false);
                }
                return new T2zosConnection(xb2, string, string2, this);
            }
        }
        throw new SqlException(xb2, "Driver type " + this.driverType + " not available for " + "IBM DB2 JDBC Universal Driver Architecture");
    }

    private void initialize() {
        if (!this.isConnectionPoolDataSourceSet && this.cpds_ != null) {
            this.cpds_.setDatabaseName(this.getDatabaseName());
            this.cpds_.setServerName(this.getServerName());
            this.cpds_.setPortNumber(this.getPortNumber());
            this.cpds_.setDriverType(this.getDriverType());
            this.cpds_.setTraceFile(this.getTraceFile());
            this.isConnectionPoolDataSourceSet = true;
        }
    }
}

