/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.erb;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.erb.ERBPlugin;
import com.aptana.ide.editor.erb.ERBSourceEditor;
import com.aptana.ide.editor.html.BrowserExtensionLoader;
import com.aptana.ide.editor.html.MultiPageHTMLEditor;
import com.aptana.ide.editor.html.preview.IBrowserTabAdder;
import com.aptana.ide.editor.html.preview.IPreviewConfigurationPage;
import com.aptana.ide.editor.html.preview.PreviewConfigurationPage;
import com.aptana.ide.editors.unified.ContributedBrowser;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.radrails.server.core.Server;
import org.radrails.server.core.ServerManager;
import org.rubypeople.rdt.core.SocketUtil;

public class ERBTabAdder
implements IBrowserTabAdder {
    private boolean autoStartServer = false;

    public IPreviewConfigurationPage[] getAddOnTabs(MultiPageHTMLEditor editor, Composite parent) {
        if (editor.getSourceEditor() instanceof ERBSourceEditor) {
            IProject project;
            int i = 1;
            while (i <= editor.getPageCount()) {
                editor.removePage(1);
                ++i;
            }
            IFile file = ERBTabAdder.getFile((IEditorPart)editor);
            if (file != null && (project = file.getProject()) != null) {
                Collection servers = ServerManager.getInstance().getServersForProject(project);
                Server runningServer = null;
                for (Server server : servers) {
                    if (!server.isStarted()) continue;
                    runningServer = server;
                    break;
                }
                if (runningServer == null) {
                    for (Server server : servers) {
                        if (!server.isLocalhost() || SocketUtil.portFree((String)server.getHost(), (int)Integer.parseInt(server.getPort()))) continue;
                        runningServer = server;
                    }
                }
                if (this.autoStartServer && runningServer == null && servers != null && !servers.isEmpty()) {
                    runningServer = (Server)servers.iterator().next();
                    runningServer.start(false);
                }
                if (runningServer != null) {
                    return ERBTabAdder.getPages(editor, runningServer, file, parent);
                }
            }
        }
        return null;
    }

    private static IFile getFile(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        if (editor.getEditorInput() instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
            return input.getFile();
        }
        return null;
    }

    private static IPreviewConfigurationPage[] getPages(MultiPageHTMLEditor editor, Server server, IFile file, Composite parent) {
        List browserList = BrowserExtensionLoader.loadBrowsers();
        IPreviewConfigurationPage[] pages = new IPreviewConfigurationPage[browserList.size()];
        String url = ERBTabAdder.getURL(server, file);
        if (url == null) {
            return null;
        }
        int j = 0;
        while (j < browserList.size()) {
            IConfigurationElement element = (IConfigurationElement)browserList.get(j);
            String name = BrowserExtensionLoader.getBrowserLabel((IConfigurationElement)element);
            try {
                Object obj = element.createExecutableExtension("class");
                if (obj instanceof ContributedBrowser) {
                    ContributedBrowser browser = (ContributedBrowser)obj;
                    pages[j] = ERBTabAdder.getPage(editor, browser, name, url, parent);
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)ERBPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
            }
            ++j;
        }
        return pages;
    }

    private static String getURL(Server server, IFile file) {
        String url = "http://" + server.getBrowserHost() + ":" + server.getPort();
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        IPath path = file.getProjectRelativePath();
        String controller = (path = path.removeFirstSegments(2)).segment(0);
        if (controller.equals("layouts")) {
            return null;
        }
        String fileName = path.lastSegment();
        if (fileName.contains(".")) {
            fileName = fileName.substring(0, fileName.indexOf(46));
        }
        path = path.removeLastSegments(1);
        if (!fileName.equals("index")) {
            path = path.append(fileName);
        }
        url = String.valueOf(url) + path.toPortableString();
        return url;
    }

    private static IPreviewConfigurationPage getPage(MultiPageHTMLEditor editor, ContributedBrowser browser, String name, String url, Composite parent) {
        PreviewConfigurationPage page = new PreviewConfigurationPage(editor);
        page.setType("com.aptana.ide.editor.html.preview.ABSOLUTE_BASED_TYPE");
        page.setValue(url);
        page.setTitle(name);
        page.createControl(parent);
        page.setBrowser(browser, name);
        page.showBrowserArea();
        return page;
    }
}

