/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.erb.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.erb.ERBPlugin;
import com.aptana.ide.editor.erb.actions.EditorMessages;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.radrails.rails.internal.core.RailsPlugin;

public class ExtractPartialAction
extends Action {
    private ITextEditor fEditor;
    private IFile fFile;
    private String fExtension;

    public ExtractPartialAction(ITextEditor editor) {
        this.setText(EditorMessages.getString("ExtractPartial.label"));
        this.fEditor = editor;
    }

    public void run() {
        ISelection sel = this.fEditor.getSelectionProvider().getSelection();
        if (this.validSelection(sel)) {
            TextSelection textSel = (TextSelection)sel;
            this.extract(textSel);
        }
    }

    private void extract(TextSelection textSel) {
        InputDialog dialog = new InputDialog(Display.getDefault().getActiveShell(), "Extract Partial", "Enter the partial name:", "", new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || newText.trim().length() == 0) {
                    return "You have entered an empty filename. Please enter at least one character.";
                }
                IFile file = ExtractPartialAction.this.getFile(newText);
                if (file.exists()) {
                    return "A file that name already exists. Please choose a new name.";
                }
                return null;
            }
        });
        if (dialog.open() != 0) {
            return;
        }
        String fileName = dialog.getValue();
        IFile file = this.getFile(fileName);
        if (!file.exists()) {
            try {
                ByteArrayInputStream bas = new ByteArrayInputStream(textSel.getText().getBytes());
                file.create((InputStream)bas, true, null);
                String replacement = "<%= render :partial => '" + file.getName().substring(1, file.getName().length() - this.getExtension().length()) + "' %>";
                this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput()).replace(textSel.getOffset(), textSel.getLength(), replacement);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)ERBPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)ERBPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    private IFile getFile(String fileName) {
        if (!(fileName = this.addExtension(fileName)).startsWith("_")) {
            fileName = "_" + fileName;
        }
        IPath path = this.getFile().getFullPath().removeLastSegments(1).append(fileName);
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    private IFile getFile() {
        IFileEditorInput fei = (IFileEditorInput)this.fEditor.getEditorInput();
        return fei.getFile();
    }

    private String addExtension(String fileName) {
        if (!fileName.endsWith(this.getExtension())) {
            return String.valueOf(fileName) + this.getExtension();
        }
        return fileName;
    }

    private String getExtension() {
        if (this.fFile == null || !this.getFile().equals((Object)this.fFile)) {
            String version;
            IProject project;
            this.fFile = this.getFile();
            this.fExtension = ".html.erb";
            if (this.fFile != null && (project = this.fFile.getProject()) != null && (version = RailsPlugin.getRailsVersion((IProject)project)) != null && (version.startsWith("1.") || version.startsWith("1."))) {
                this.fExtension = ".rhtml";
            }
        }
        return this.fExtension;
    }

    private boolean validSelection(ISelection sel) {
        return sel != null && sel instanceof TextSelection && !sel.isEmpty();
    }
}

