/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.erb.contentassist;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.erb.ERBPlugin;
import com.aptana.ide.editor.erb.contentassist.ERBCompletionProposal;
import com.aptana.ide.editor.erb.contentassist.LazyERBCompletionProposal;
import com.aptana.ide.editor.erb.contentassist.PartialProposal;
import com.aptana.ide.editor.erb.contentassist.RhtmlTemplateManager;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IUnifiedViewer;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.radrails.rails.core.RailsConventions;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.ui.text.RailsHeuristicCompletionComputer;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.CollectingSearchRequestor;
import org.rubypeople.rdt.core.search.FieldReferenceMatch;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.MethodReferenceMatch;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.core.search.SearchMatch;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.core.search.SearchRequestor;
import org.rubypeople.rdt.core.search.TypeNameRequestor;
import org.rubypeople.rdt.internal.core.RubyGlobal;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.corext.util.RDocUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyCompletionProcessor;
import org.rubypeople.rdt.internal.ui.text.template.contentassist.RubyTemplateAccess;
import org.rubypeople.rdt.ui.RubyElementLabelProvider;
import org.rubypeople.rdt.ui.text.RubyTextTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERBContentAssistProcessor
extends TemplateCompletionProcessor
implements IContentAssistProcessor {
    private static final String APPLICATION_CONTROLLER_CLASSNAME = "ApplicationController";
    private static final String APPLICATION_HELPER_FILENAME = "application_helper.rb";
    private static final String APPLICATION_CONTROLLER_FILENAME = "application.rb";
    private static final String PERFORMANCE_EVENT = "com.aptana.ide.editor.erb/perf/content_assist";
    private static final boolean MEASURE_PERFORMANCE = PerformanceStats.isEnabled((String)"com.aptana.ide.editor.erb/perf/content_assist");
    private static final String HELPERS = "helpers";
    private static final String CONTROLLERS = "controllers";
    private static final String HELPER_METHOD = "helper_method";
    private static Image fIconKeyword = UnifiedEditorsPlugin.getImage((String)"icons/keyword.gif");
    private static Image fIconTemplate = ERBPlugin.getImage("icons/rails.gif");
    private EditorFileContext fContext;
    private static RubyElementLabelProvider labelProvider = new RubyElementLabelProvider();
    private int fOffset;
    private IUnifiedViewer unifiedViewer;
    private String fPrefix = "";
    private IEditorPart fEditor;
    private static List<CachedProposal> fgActionViewHelpers;
    private static String[] keywordProposals;
    private static String[] preDefinedGlobals;
    private static String[] globalContexts;

    static {
        preDefinedGlobals = new String[]{"$!", "$@", "$_", "$.", "$&", "$n", "$~", "$=", "$/", "$\\", "$0", "$*", "$$", "$?", "$:"};
        globalContexts = new String[]{"error message", "position of an error occurrence", "latest read string by `gets'", "latest read number of line by interpreter", "latest matched string by the regexep.", "latest matched string by nth parentheses of regexp.", "data for latest matche for regexp", "whether or not case-sensitive in string matching", "input record separator", "output record separator", "the name of the ruby script file", "command line arguments for the ruby scpript", "PID for ruby interpreter", "status of the latest executed child process", "array of paths that ruby interpreter searches for files"};
    }

    public ERBContentAssistProcessor(IEditorPart editor, EditorFileContext context) {
        this.fEditor = editor;
        this.fContext = context;
    }

    private File getControllersFolder() {
        File dir;
        block11: {
            block10: {
                block9: {
                    IFolder folder;
                    block8: {
                        IPath view;
                        block7: {
                            try {
                                view = this.getViewPath();
                                if (view != null) break block7;
                                return null;
                            }
                            catch (Exception exception) {
                                return null;
                            }
                        }
                        folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(view.removeLastSegments(1));
                        if (folder != null) break block8;
                        return null;
                    }
                    dir = folder.getLocation().toFile();
                    if (dir != null) break block9;
                    return null;
                }
                dir = dir.getParentFile();
                if (dir != null) break block10;
                return null;
            }
            dir = dir.getParentFile();
            if (dir != null) break block11;
            return null;
        }
        return new File(dir, CONTROLLERS);
    }

    /*
     * Exception decompiling
     */
    protected String extractPrefix(ITextViewer viewer, int offset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        PerformanceStats stats;
        boolean isDebug = this.isDebug();
        if (MEASURE_PERFORMANCE || isDebug) {
            stats = PerformanceStats.getStats((String)PERFORMANCE_EVENT, (Object)((Object)this));
            stats.startRun("computeCompletionProposals()");
        } else {
            stats = null;
        }
        long start = System.currentTimeMillis();
        this.fOffset = offset;
        if (viewer instanceof IUnifiedViewer) {
            this.unifiedViewer = (IUnifiedViewer)viewer;
        }
        this.fPrefix = this.getPrefix(viewer.getDocument(), offset);
        long prefix = System.currentTimeMillis();
        ArrayList<Object> list = new ArrayList<Object>();
        if (isDebug) {
            this.log(ERBPlugin.getDefault(), "trying completions for :controller => hash values");
        }
        list.addAll(this.tryControllerCompletions());
        if (!list.isEmpty()) {
            return list.toArray(new ICompletionProposal[list.size()]);
        }
        if (isDebug) {
            this.log(ERBPlugin.getDefault(), "trying completions for :action => hash values");
        }
        list.addAll(this.tryActionCompletions());
        if (!list.isEmpty()) {
            return list.toArray(new ICompletionProposal[list.size()]);
        }
        if (isDebug) {
            this.log(ERBPlugin.getDefault(), "trying completions for :partial => hash values");
        }
        list.addAll(this.tryPartialCompletions());
        if (!list.isEmpty()) {
            return list.toArray(new ICompletionProposal[list.size()]);
        }
        long special = System.currentTimeMillis();
        if (isDebug) {
            this.log(ERBPlugin.getDefault(), "trying Ruby completions");
        }
        ContentAssistant assist = new ContentAssistant();
        RubyCompletionProcessor p = new RubyCompletionProcessor(this.fEditor, assist, "__dftl_partition_content_type");
        ICompletionProposal[] originals = p.computeCompletionProposals(viewer, this.fOffset);
        list.addAll((Collection)Arrays.asList(originals));
        long completions = System.currentTimeMillis();
        long controllerInstance = 0L;
        long matchingHelper = 0L;
        long appHelper = 0L;
        long actionViewHelpers = 0L;
        if (this.indicesAreReady()) {
            if (isDebug) {
                this.log(ERBPlugin.getDefault(), "Search indices are ready...");
                this.log(ERBPlugin.getDefault(), "trying completions for instance variables defined in matching action in controller");
            }
            IType relatedController = this.getController();
            list.addAll(this.getControllerInstanceVariables(relatedController));
            controllerInstance = System.currentTimeMillis();
            if (isDebug) {
                this.log(ERBPlugin.getDefault(), "trying completions for methods in helper");
            }
            list.addAll(this.getHelperMethods(this.getRelatedHelper()));
            matchingHelper = System.currentTimeMillis();
            if (isDebug) {
                this.log(ERBPlugin.getDefault(), "trying completions for methods in aplication_helper.rb");
            }
            list.addAll(this.getHelperMethods(this.getApplicationHelper()));
            appHelper = System.currentTimeMillis();
            if (isDebug) {
                this.log(ERBPlugin.getDefault(), "trying completions for ActionView helpers in Rails");
            }
            list.addAll(this.getActionViewHelpers());
            actionViewHelpers = System.currentTimeMillis();
            if (isDebug) {
                this.log(ERBPlugin.getDefault(), "trying completions for controller methods marked as helper");
            }
            list.addAll(this.getControllerMethodsMarkedAsHelper(relatedController));
            if (isDebug) {
                this.log(ERBPlugin.getDefault(), "trying completions for controller methods marked as helper in application_controller.rb");
            }
            list.addAll(this.getControllerMethodsMarkedAsHelper(this.getApplicationController()));
            Collections.sort(list, new Comparator<ICompletionProposal>(){

                @Override
                public int compare(ICompletionProposal o1, ICompletionProposal o2) {
                    return o1.getDisplayString().compareTo(o2.getDisplayString());
                }
            });
        }
        if (isDebug) {
            this.log(ERBPlugin.getDefault(), "trying completions for keywords");
        }
        long keywordStart = System.currentTimeMillis();
        list.addAll((Collection)Arrays.asList(this.determineKeywordProposals(viewer, offset)));
        if (isDebug) {
            this.log(ERBPlugin.getDefault(), "trying completions for templates");
        }
        long keywords = System.currentTimeMillis();
        list.addAll((Collection)Arrays.asList(this.determineTemplateProposals(viewer, offset)));
        long templates = System.currentTimeMillis();
        Collections.sort(list, new Comparator<ICompletionProposal>(){

            @Override
            public int compare(ICompletionProposal o1, ICompletionProposal o2) {
                if (o1 != null && o1.getDisplayString() != null && o2 != null && o2.getDisplayString() != null) {
                    return o1.getDisplayString().compareToIgnoreCase(o2.getDisplayString());
                }
                return 0;
            }
        });
        long sort = System.currentTimeMillis();
        if (MEASURE_PERFORMANCE || isDebug) {
            stats.endRun();
            long end = System.currentTimeMillis();
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            PerformanceStats.printStats((PrintWriter)writer);
            this.log(ERBPlugin.getDefault(), stringWriter.getBuffer().toString());
            this.log(ERBPlugin.getDefault(), "ERB Assist (total): " + (end - start));
            this.log(ERBPlugin.getDefault(), "ERB Assist (grabbing prefix): " + (prefix - start));
            this.log(ERBPlugin.getDefault(), "ERB Assist (special cases): " + (special - prefix));
            this.log(ERBPlugin.getDefault(), "ERB Assist (Normal Completions): " + (completions - special));
            this.log(ERBPlugin.getDefault(), "ERB Assist (Controller instance vars): " + (controllerInstance - completions));
            this.log(ERBPlugin.getDefault(), "ERB Assist (Matching helper): " + (matchingHelper - controllerInstance));
            this.log(ERBPlugin.getDefault(), "ERB Assist (App helper): " + (appHelper - matchingHelper));
            this.log(ERBPlugin.getDefault(), "ERB Assist (Action View Helpers): " + (actionViewHelpers - appHelper));
            this.log(ERBPlugin.getDefault(), "ERB Assist (keywords): " + (keywords - keywordStart));
            this.log(ERBPlugin.getDefault(), "ERB Assist (templates): " + (templates - keywords));
            this.log(ERBPlugin.getDefault(), "ERB Assist (Sorting): " + (sort - templates));
        }
        return list.toArray(new ICompletionProposal[list.size()]);
    }

    private IRubyScript getApplicationHelper() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        IPath railsRoot = RailsPlugin.findRailsRoot((IProject)project);
        if (railsRoot == null) {
            railsRoot = new Path("");
        }
        IPath applicationControllerPath = railsRoot.append(HELPERS).append(APPLICATION_HELPER_FILENAME);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = workspaceRoot.getFile(applicationControllerPath);
        return RubyCore.create((IFile)file);
    }

    private IType getApplicationController() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        IPath railsRoot = RailsPlugin.findRailsRoot((IProject)project);
        if (railsRoot == null) {
            railsRoot = new Path("");
        }
        IPath applicationControllerPath = railsRoot.append(CONTROLLERS).append(APPLICATION_CONTROLLER_FILENAME);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = workspaceRoot.getFile(applicationControllerPath);
        IRubyScript script = RubyCore.create((IFile)file);
        if (script == null) {
            return null;
        }
        return script.getType(APPLICATION_CONTROLLER_CLASSNAME);
    }

    private IProject getProject() {
        IFile viewFile = this.getViewFile();
        if (viewFile == null) {
            return null;
        }
        return viewFile.getProject();
    }

    private IRubyScript getRelatedHelper() {
        IFile helperFile = RailsConventions.getHelperFromView((IFile)this.getViewFile());
        if (helperFile == null) {
            return null;
        }
        return RubyCore.create((IFile)helperFile);
    }

    private void log(ERBPlugin plugin, String string) {
        IdeLog.log((Plugin)plugin, (int)1, (String)string, null);
    }

    private Collection<? extends ICompletionProposal> tryPartialCompletions() {
        ArrayList<ICompletionProposal> list = new ArrayList<ICompletionProposal>();
        String fullPrefix = this.getFullPrefix(this.unifiedViewer.getDocument(), this.fOffset);
        if (this.looksLikePartialValue(fullPrefix)) {
            list.addAll(this.getPartialsCompletions(fullPrefix, this.fOffset));
        }
        return list;
    }

    private Collection<? extends ICompletionProposal> tryActionCompletions() {
        Map completions = RailsHeuristicCompletionComputer.getActionCompletions((File)this.getControllersFolder(), (IDocument)this.unifiedViewer.getDocument(), (int)this.fOffset);
        return this.tryCompletions(completions);
    }

    private Collection<? extends ICompletionProposal> tryControllerCompletions() {
        Map completions = RailsHeuristicCompletionComputer.getControllerCompletions((File)this.getControllersFolder(), (IDocument)this.unifiedViewer.getDocument(), (int)this.fOffset);
        return this.tryCompletions(completions);
    }

    private Collection<? extends ICompletionProposal> tryCompletions(Map<String, File> completions) {
        ArrayList<ERBCompletionProposal> list = new ArrayList<ERBCompletionProposal>();
        if (completions == null || completions.isEmpty()) {
            return list;
        }
        for (String replacement : completions.keySet()) {
            ERBCompletionProposal prop = new ERBCompletionProposal(replacement, this.fOffset, 0, replacement.length(), null, replacement, null, null, -1, this.unifiedViewer, null, completions.get(replacement).getAbsolutePath());
            list.add(prop);
        }
        return list;
    }

    private boolean looksLikePartialValue(String fullPrefix) {
        return Pattern.matches(".*:partial\\s*=>\\s*['|\"]?", fullPrefix);
    }

    private List<ICompletionProposal> getPartialsCompletions(String fullPrefix, int offset) {
        ArrayList<ICompletionProposal> list = new ArrayList<ICompletionProposal>();
        File[] partials = this.getPartials();
        int i = 0;
        while (i < partials.length) {
            File partial = partials[i];
            String filename = partial.getName();
            String name = filename.substring(1);
            if (name.endsWith(".rhtml")) {
                name = name.substring(0, name.length() - 6);
            } else if (name.endsWith(".erb.html")) {
                name = name.substring(0, name.length() - 9);
            }
            IPath view = this.getViewPath().removeLastSegments(1);
            IFolder viewsFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(view);
            String viewsFolderPath = viewsFolder.getLocation().toOSString();
            String absolutePath = partial.getAbsolutePath();
            if (!absolutePath.startsWith(viewsFolderPath)) {
                String parentName = partial.getParentFile().getName();
                name = String.valueOf(parentName) + '/' + name;
                filename = String.valueOf(parentName) + '/' + filename;
            }
            String replacement = name;
            int next = 97;
            try {
                if (offset < this.unifiedViewer.getDocument().getLength()) {
                    next = this.unifiedViewer.getDocument().getChar(offset);
                }
            }
            catch (BadLocationException badLocationException) {}
            if (fullPrefix.endsWith("'")) {
                if (next != 39) {
                    replacement = String.valueOf(replacement) + "'";
                }
            } else if (fullPrefix.endsWith("\"")) {
                if (next != 34) {
                    replacement = String.valueOf(replacement) + "\"";
                }
            } else {
                replacement = "'" + replacement + "'";
            }
            PartialProposal prop = new PartialProposal(partial, replacement, offset, name, this.unifiedViewer, filename);
            list.add((ICompletionProposal)prop);
            ++i;
        }
        return list;
    }

    private File[] getPartials() {
        IPath view = this.getViewPath();
        File dir = ResourcesPlugin.getWorkspace().getRoot().getFolder(view.removeLastSegments(1)).getLocation().toFile();
        File viewsDir = dir.getParentFile();
        List<File> partials = this.getPartials(viewsDir);
        return partials.toArray(new File[partials.size()]);
    }

    private List<File> getPartials(File dir) {
        File[] subdirs = this.getSubdirectories(dir);
        ArrayList<File> list = new ArrayList<File>();
        int i = 0;
        while (i < subdirs.length) {
            File[] partials = subdirs[i].listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("_");
                }
            });
            int j = 0;
            while (j < partials.length) {
                list.add(partials[j]);
                ++j;
            }
            list.addAll(this.getPartials(subdirs[i]));
            ++i;
        }
        return list;
    }

    private File[] getSubdirectories(File viewsDir) {
        return viewsDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
    }

    private boolean indicesAreReady() {
        SearchEngine engine = new SearchEngine();
        IRubySearchScope scope = SearchEngine.createWorkspaceScope();
        try {
            engine.searchAllTypeNames(null, "!@$#!@".toCharArray(), 10, 4, scope, new TypeNameRequestor(){

                public void acceptType(boolean isModule, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                }
            }, 2, null);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private List<ICompletionProposal> getControllerMethodsMarkedAsHelper(IType controller) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (controller == null || !controller.exists()) {
            return proposals;
        }
        List<SearchMatch> matches = this.search((IRubyElement)controller, HELPER_METHOD, 6, 1);
        for (SearchMatch match : matches) {
            if (!(match instanceof MethodReferenceMatch)) continue;
            MethodReferenceMatch refMatch = (MethodReferenceMatch)match;
            List arguments = refMatch.getArguments();
            for (String arg : arguments) {
                IMethod method = this.getMethod(controller, arg);
                ICompletionProposal proposal = this.createProposal((IRubyElement)method);
                if (proposal == null) continue;
                proposals.add(proposal);
            }
        }
        return proposals;
    }

    private IType getController() {
        IType[] types;
        block3: {
            try {
                IFile controllerFile = RailsConventions.getControllerFromView((IFile)this.getViewFile());
                IRubyScript controllerScript = RubyCore.create((IFile)controllerFile);
                types = controllerScript.getTypes();
                if (types != null && types.length != 0) break block3;
                return null;
            }
            catch (RubyModelException e) {
                IdeLog.logError((Plugin)ERBPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return types[0];
    }

    private IRubyProject getRubyProject() {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.getViewPath());
        return RubyModelManager.getRubyModelManager().getRubyModel().getRubyProject((IResource)file);
    }

    private IPath getViewPath() {
        String uriString = this.fContext.getSourceProvider().getSourceURI();
        URI uri = URI.create(uriString);
        File aFile = new File(uri.getPath());
        IPath viewPath = Path.fromOSString((String)aFile.getAbsolutePath());
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPath rootPath = workspaceRoot.getLocation();
        if (rootPath.isPrefixOf(viewPath)) {
            viewPath = viewPath.removeFirstSegments(rootPath.segmentCount());
        }
        return viewPath.setDevice(null);
    }

    private List<ICompletionProposal> getActionViewHelpers() {
        if (fgActionViewHelpers == null || fgActionViewHelpers.isEmpty()) {
            long start = System.currentTimeMillis();
            ArrayList<CachedProposal> proposals = new ArrayList<CachedProposal>();
            ISourceFolderRoot root = this.getActionPackSourceRoot();
            long actionPackRoot = System.currentTimeMillis();
            if (root == null) {
                return new ArrayList<ICompletionProposal>();
            }
            ISourceFolder helperFolder = root.getSourceFolder(new String[]{"action_view", HELPERS});
            long sourceFolder = System.currentTimeMillis();
            List<SearchMatch> matches = this.search((IRubyElement)helperFolder, 6, 0);
            long finishedSearch = System.currentTimeMillis();
            for (SearchMatch match : matches) {
                IRubyElement element = (IRubyElement)match.getElement();
                if (!(element instanceof IMethod)) continue;
                IMethod method = (IMethod)element;
                try {
                    if (!method.isPublic() || !method.getDeclaringType().getElementName().endsWith("Helper")) continue;
                    proposals.add(new CachedProposal(element));
                }
                catch (RubyModelException e) {
                    ERBPlugin.getDefault().getLog().log(e.getStatus());
                }
            }
            if (MEASURE_PERFORMANCE) {
                long end = System.currentTimeMillis();
                System.err.println("Action View Helper Methods (total): " + (end - start));
                System.err.println("Action View Helper Methods (grab root): " + (actionPackRoot - start));
                System.err.println("Action View Helper Methods (helper folder): " + (sourceFolder - actionPackRoot));
                System.err.println("Action View Helper Methods (search): " + (finishedSearch - sourceFolder));
            }
            fgActionViewHelpers = proposals;
        }
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (CachedProposal cached : fgActionViewHelpers) {
            ERBCompletionProposal proposal = cached.getProposal(this.fOffset, this.fPrefix, this.unifiedViewer);
            if (!proposal.getDisplayString().startsWith(this.fPrefix)) continue;
            proposals.add((ICompletionProposal)proposal);
        }
        return proposals;
    }

    private ISourceFolderRoot getActionPackSourceRoot() {
        try {
            ISourceFolderRoot[] roots = this.getRubyProject().getSourceFolderRoots();
            int i = 0;
            while (i < roots.length) {
                String gem;
                ISourceFolderRoot root = roots[i];
                IPath path = root.getPath();
                if (path.segmentCount() >= 2 && (gem = path.segment(path.segmentCount() - 2)).startsWith("actionpack")) {
                    return root;
                }
                ++i;
            }
        }
        catch (RubyModelException e) {
            ERBPlugin.getDefault().getLog().log(e.getStatus());
        }
        return null;
    }

    private ICompletionProposal[] determineKeywordProposals(ITextViewer viewer, int documentOffset) {
        this.initKeywordProposals();
        List<String> completionProposals = Arrays.asList(keywordProposals);
        ArrayList<ERBCompletionProposal> possibleProposals = new ArrayList<ERBCompletionProposal>();
        int i = 0;
        while (i < completionProposals.size()) {
            String proposal = completionProposals.get(i);
            if (proposal.startsWith(this.fPrefix)) {
                String message = this.isPredefinedGlobal(proposal) ? "{0} " + this.getContext(proposal) : "The <b>{0}</b> keyword";
                String popupInfo = MessageFormat.format(message, proposal);
                ContextInformation info = new ContextInformation(proposal, popupInfo);
                String replacementString = proposal.substring(this.fPrefix.length(), proposal.length());
                Image icon = fIconKeyword;
                String decription = "Keyword";
                if (proposal.startsWith("$")) {
                    icon = labelProvider.getImage((Object)new RubyGlobal(null, proposal));
                    decription = "Global";
                }
                ERBCompletionProposal proposalObj = new ERBCompletionProposal(replacementString, documentOffset, 0, proposal.length() - this.fPrefix.length(), icon, proposal, (IContextInformation)info, popupInfo, 0, null, null, decription);
                possibleProposals.add(proposalObj);
            }
            ++i;
        }
        return possibleProposals.toArray(new ICompletionProposal[possibleProposals.size()]);
    }

    private String getContext(String proposal) {
        int i = 0;
        while (i < preDefinedGlobals.length) {
            if (proposal.equals(preDefinedGlobals[i])) {
                return globalContexts[i];
            }
            ++i;
        }
        return "";
    }

    private boolean isPredefinedGlobal(String proposal) {
        int i = 0;
        while (i < preDefinedGlobals.length) {
            if (proposal.equals(preDefinedGlobals[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void initKeywordProposals() {
        if (keywordProposals == null) {
            String[] keywords = RubyTextTools.getKeyWords();
            keywordProposals = new String[keywords.length + preDefinedGlobals.length];
            System.arraycopy(keywords, 0, keywordProposals, 0, keywords.length);
            System.arraycopy(preDefinedGlobals, 0, keywordProposals, keywords.length, preDefinedGlobals.length);
        }
    }

    private IFile getViewFile() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        return workspaceRoot.getFile(this.getViewPath());
    }

    private List<ICompletionProposal> getHelperMethods(IRubyScript helper) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (helper == null) {
            return proposals;
        }
        List<SearchMatch> matches = this.search((IRubyElement)helper, 6, 0);
        for (SearchMatch match : matches) {
            IRubyElement element = (IRubyElement)match.getElement();
            ICompletionProposal proposal = this.createProposal(element);
            if (proposal == null) continue;
            proposals.add(proposal);
        }
        return proposals;
    }

    private String getActionName() {
        String viewName = this.getViewPath().lastSegment();
        if (viewName.endsWith(".rhtml")) {
            return viewName.substring(0, viewName.length() - ".rhtml".length());
        }
        if (viewName.endsWith(".html.erb")) {
            return viewName.substring(0, viewName.length() - ".html.erb".length());
        }
        RubyPlugin.log((String)"uh oh, we have a view without an .rhtml or .html.erb ending! We'll just take up until first period.");
        return viewName.substring(0, viewName.indexOf(46));
    }

    private List<ICompletionProposal> getControllerInstanceVariables(IType controller) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (controller == null || !controller.exists()) {
            return proposals;
        }
        IMethod action = this.getMethod(controller, this.getActionName());
        List<SearchMatch> matches = this.search((IRubyElement)action, 11, 2);
        for (SearchMatch match : matches) {
            ICompletionProposal proposal;
            IRubyElement element = null;
            if (match instanceof FieldReferenceMatch) {
                FieldReferenceMatch fieldRef = (FieldReferenceMatch)match;
                element = fieldRef.getBinding();
            } else {
                element = (IRubyElement)match.getElement();
            }
            if (!element.getParent().equals(controller) || (proposal = this.createProposal(element)) == null) continue;
            proposals.add(proposal);
        }
        return proposals;
    }

    private List<SearchMatch> search(IRubyElement scopeElement, int searchType, int categories) {
        return this.search(scopeElement, "*", searchType, categories);
    }

    private List<SearchMatch> search(IRubyElement scopeElement, String string, int searchType, int categories) {
        if (scopeElement == null) {
            return Collections.emptyList();
        }
        IRubySearchScope scope = SearchEngine.createRubySearchScope((IRubyElement[])new IRubyElement[]{scopeElement});
        SearchEngine engine = new SearchEngine();
        SearchPattern pattern = SearchPattern.createPattern((int)searchType, (String)string, (int)categories, (int)2);
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        CollectingSearchRequestor requestor = new CollectingSearchRequestor();
        try {
            engine.search(pattern, participants, scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            RubyPlugin.log((Throwable)e);
        }
        return requestor.getResults();
    }

    private ICompletionProposal createProposal(IRubyElement element) {
        String name = element.getElementName();
        if (!name.startsWith(this.fPrefix)) {
            return null;
        }
        return new ERBCompletionProposal(name, this.fOffset - this.fPrefix.length(), this.fPrefix.length(), name.length(), labelProvider.getImage((Object)element), name, null, RDocUtil.getHTMLDocumentation((IRubyElement)element), element.getElementType(), this.unifiedViewer, null, element.getPath().toOSString());
    }

    private IMethod getMethod(IType type, String methodName) {
        try {
            IMethod[] methods = type.getMethods();
            int i = 0;
            while (i < methods.length) {
                if (methods[i].getElementName().equals(methodName)) {
                    return methods[i];
                }
                ++i;
            }
        }
        catch (RubyModelException e) {
            RubyPlugin.log((Throwable)e);
        }
        return null;
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return RhtmlTemplateManager.getDefault().getContextTypeRegistry().getContextType("org.radrails.rails.ui.templateContextType.rhtml");
    }

    protected Image getImage(Template template) {
        return fIconTemplate;
    }

    private String getFullPrefix(IDocument doc, int offset) {
        int length = 0;
        String prefix = "";
        try {
            while (offset - length > 0 && Pattern.matches("[^\\n|^\\r|^;]", doc.get(offset - length - 1, 1))) {
                ++length;
            }
            prefix = doc.get(offset - length, length);
        }
        catch (BadLocationException badLocationException) {}
        return prefix;
    }

    private String getPrefix(IDocument doc, int offset) {
        int length = 0;
        String prefix = "";
        try {
            while (offset - length > 0 && Pattern.matches("[\\w|@|$|:]", doc.get(offset - length - 1, 1))) {
                ++length;
            }
            prefix = doc.get(offset - length, length);
        }
        catch (BadLocationException badLocationException) {}
        return prefix;
    }

    private ICompletionProposal[] determineTemplateProposals(ITextViewer refViewer, int documentOffset) {
        if (this.fPrefix.length() == 0) {
            return super.computeCompletionProposals(refViewer, documentOffset);
        }
        ICompletionProposal[] templateProposals = super.computeCompletionProposals(refViewer, documentOffset);
        ArrayList<ICompletionProposal> templateProposalList = new ArrayList<ICompletionProposal>(templateProposals.length);
        int i = 0;
        while (i < templateProposals.length) {
            if (templateProposals[i].getDisplayString().toLowerCase().startsWith(this.fPrefix)) {
                templateProposalList.add(templateProposals[i]);
            }
            ++i;
        }
        return templateProposalList.toArray(new ICompletionProposal[templateProposalList.size()]);
    }

    protected Template[] getTemplates(String contextTypeId) {
        Template[] rhtml = RhtmlTemplateManager.getDefault().getTemplateStore().getTemplates();
        Template[] ruby = RubyTemplateAccess.getDefault().getTemplateStore().getTemplates();
        Template[] superSet = new Template[rhtml.length + ruby.length];
        System.arraycopy(rhtml, 0, superSet, 0, rhtml.length);
        System.arraycopy(ruby, 0, superSet, rhtml.length, ruby.length);
        return superSet;
    }

    private boolean isDebug() {
        return ERBPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editor.erb.ERBEDITOR_CONTENT_ASSIST_DEBUG");
    }

    private static class CachedProposal {
        private String name;
        private String path;
        private int type;
        private Image image;
        private IRubyElement element;

        public CachedProposal(IRubyElement element) {
            this.name = element.getElementName();
            this.path = element.getPath().toOSString();
            this.element = element;
            this.type = element.getElementType();
            this.image = labelProvider.getImage((Object)element);
        }

        public ERBCompletionProposal getProposal(int offset, String prefix, IUnifiedViewer unifiedViewer) {
            return new LazyERBCompletionProposal(this.element, this.name, offset - prefix.length(), prefix.length(), this.name.length(), this.image, this.name, null, null, this.type, unifiedViewer, null, this.path);
        }
    }
}

