/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.erb.contentassist;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.erb.ERBPlugin;
import com.aptana.ide.editor.erb.contentassist.RhtmlTemplateManager;
import com.aptana.ide.editor.erb.contentassist.WordPartDetector;
import com.aptana.ide.editors.unified.contentassist.ICompletionProposalContributor;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditorMessages;

public class ERBTemplateCompletionProposalContributor
extends TemplateCompletionProcessor
implements ICompletionProposalContributor {
    private static final Image templateImage = ERBPlugin.imageDescriptorFromPlugin((String)"com.aptana.ide.editor.erb", (String)"icons/rails.gif").createImage();
    private static final char[] COMPLETION_CHARS = new char[]{'.'};
    protected Vector proposalList = new Vector();
    protected IContextInformationValidator validator = new Validator();
    private ITextViewer viewer;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset, int position, LexemeList lexemeList, char activationChar, char previousChar) {
        return this.computeCompletionProposals(viewer, offset, position, lexemeList, activationChar, previousChar, false);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset, int position, LexemeList lexemeList, char activationChar, char previousChar, boolean autoActivated) {
        if (autoActivated) {
            return new ICompletionProposal[0];
        }
        Lexeme lex = lexemeList.getLexemeFromOffset(offset);
        if (lex != null && lex.getText().equals("\"\"")) {
            return new ICompletionProposal[0];
        }
        return this.computeCompletionProposals(viewer, offset);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        this.viewer = viewer;
        WordPartDetector wordPart = new WordPartDetector(viewer, documentOffset);
        return this.turnProposalVectorIntoAdaptedArray(wordPart, viewer, documentOffset);
    }

    protected ICompletionProposal[] turnProposalVectorIntoAdaptedArray(WordPartDetector word, ITextViewer viewer, int documentOffset) {
        ICompletionProposal[] templates = this.determineTemplateProposals(viewer, documentOffset);
        return templates;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        IContextInformation[] result = new IContextInformation[5];
        int i = 0;
        while (i < result.length) {
            result[i] = new ContextInformation(MessageFormat.format(RubyEditorMessages.getResourceBundle().getString("CompletionProcessor.ContextInfo.display.pattern"), new Integer(i), new Integer(offset)), MessageFormat.format(RubyEditorMessages.getResourceBundle().getString("CompletionProcessor.ContextInfo.value.pattern"), new Integer(i), new Integer(offset - 5), new Integer(offset + 5)));
            ++i;
        }
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return COMPLETION_CHARS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.validator;
    }

    protected String getPrefix(IDocument doc, int offset) {
        int length = 0;
        String prefix = null;
        try {
            while (offset - length > 0 && Pattern.matches("\\w", doc.get(offset - length - 1, 1))) {
                ++length;
            }
            prefix = doc.get(offset - length, length);
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)ERBPlugin.getDefault(), (String)"Error gathering proposal prefix", (Throwable)e);
        }
        return prefix;
    }

    /*
     * Exception decompiling
     */
    protected String extractPrefix(ITextViewer viewer, int offset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ICompletionProposal[] determineTemplateProposals(ITextViewer refViewer, int documentOffset) {
        ICompletionProposal[] matchingTemplateProposals;
        String prefix = this.getPrefix(this.viewer.getDocument(), documentOffset);
        if (prefix.length() == 0) {
            matchingTemplateProposals = super.computeCompletionProposals(refViewer, documentOffset);
        } else {
            ICompletionProposal[] templateProposals = super.computeCompletionProposals(refViewer, documentOffset);
            ArrayList<ICompletionProposal> templateProposalList = new ArrayList<ICompletionProposal>(templateProposals.length);
            int i = 0;
            while (i < templateProposals.length) {
                if (templateProposals[i].getDisplayString().toLowerCase().startsWith(prefix)) {
                    templateProposalList.add(templateProposals[i]);
                }
                ++i;
            }
            matchingTemplateProposals = templateProposalList.toArray(new ICompletionProposal[templateProposalList.size()]);
        }
        Arrays.sort(matchingTemplateProposals, new TemplateProposalComparator());
        return matchingTemplateProposals;
    }

    protected Template[] getTemplates(String contextTypeId) {
        return RhtmlTemplateManager.getDefault().getTemplateStore().getTemplates();
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return RhtmlTemplateManager.getDefault().getContextTypeRegistry().getContextType("org.radrails.rails.ui.templateContextType.rhtml");
    }

    protected Image getImage(Template template) {
        return templateImage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TemplateProposalComparator
    implements Comparator<ICompletionProposal> {
        TemplateProposalComparator() {
        }

        @Override
        public int compare(ICompletionProposal filea, ICompletionProposal fileb) {
            return filea.getDisplayString().compareToIgnoreCase(fileb.getDisplayString());
        }
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int fInstallOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(this.fInstallOffset - offset) < 5;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.fInstallOffset = offset;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

