/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.erb.contentassist;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.erb.ERBPlugin;
import com.aptana.ide.editor.erb.contentassist.ERBCompletionProposal;
import com.aptana.ide.editors.unified.IUnifiedViewer;
import java.io.File;
import java.io.IOException;
import java.text.StringCharacterIterator;
import org.eclipse.core.runtime.Plugin;
import org.rubypeople.rdt.core.util.Util;

class PartialProposal
extends ERBCompletionProposal {
    private File partial;
    private String fAdditional;

    PartialProposal(File partial, String replacement, int offset, String displayString, IUnifiedViewer unifiedViewer, String filename) {
        super(replacement, offset, 0, replacement.length(), ERBPlugin.getImage("icons/page_code.png"), displayString, null, null, -1, unifiedViewer, null, filename);
        this.partial = partial;
    }

    public String getAdditionalProposalInfo() {
        if (this.fAdditional == null) {
            this.fAdditional = "";
            try {
                this.fAdditional = new String(Util.getFileCharContent((File)this.partial, null));
                this.fAdditional = PartialProposal.escapeHTML(this.fAdditional);
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)ERBPlugin.getDefault(), (String)"Problem reading partial's contents", (Throwable)e);
            }
        }
        return this.fAdditional;
    }

    public static String escapeHTML(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '&') {
                result.append("&amp;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '(') {
                result.append("&#040;");
            } else if (character == ')') {
                result.append("&#041;");
            } else if (character == '#') {
                result.append("&#035;");
            } else if (character == '%') {
                result.append("&#037;");
            } else if (character == ';') {
                result.append("&#059;");
            } else if (character == '+') {
                result.append("&#043;");
            } else if (character == '-') {
                result.append("&#045;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }
}

