/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.erb.parsing;

import com.aptana.ide.editor.erb.lexing.ERBTokenList;
import com.aptana.ide.editor.erb.lexing.RubyTokenTypes;
import com.aptana.ide.editor.erb.parsing.AptanaRubyCommentScanner;
import com.aptana.ide.editor.erb.parsing.AptanaSingleTokenRubyScanner;
import com.aptana.ide.editor.erb.parsing.ERBParseState;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.parsing.UnifiedParser;
import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.ITokenList;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.lexer.TokenList;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.ParserInitializationException;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.text.ParseException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.MergingPartitionScanner;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyTokenScanner;
import org.rubypeople.rdt.ui.text.IColorManager;

public class ERBParser
extends UnifiedParser {
    private LexemeList lexemeList;
    private int index;

    public ERBParser() throws ParserInitializationException {
        super("text/ruby");
    }

    protected ITokenList createLanguageTokenList() {
        return new ERBTokenList();
    }

    public IParseState createParseState(IParseState parent) {
        ERBParseState result = parent == null ? new ERBParseState() : new ERBParseState(parent);
        return result;
    }

    public void initializeLexer() throws LexerException {
        ILexer lexer = this.getLexer();
        String language = this.getLanguage();
        lexer.setIgnoreSet(language, new int[]{1});
        lexer.setLanguageAndGroup(language, "default");
    }

    public void parseAll(IParseNode parentNode) throws ParseException, LexerException {
        ILexer lexer = this.getLexer();
        lexer.setLanguageAndGroup(this.getLanguage(), "default");
        String source = lexer.getSource();
        source = source.substring(lexer.getCurrentOffset(), lexer.getEOFOffset());
        try {
            this.lexemeList = new LexemeList();
            this.index = 0;
            int start = lexer.getCurrentOffset();
            Document document = new Document(source);
            MergingPartitionScanner scanner = new MergingPartitionScanner();
            scanner.setRange((IDocument)document, 0, source.length());
            IToken token1 = scanner.nextToken();
            while (!token1.isEOF()) {
                int scannerOffset = scanner.getTokenOffset();
                int scannerLength = scanner.getTokenLength();
                String partitionName = (String)token1.getData();
                this.scanPartition((IDocument)document, partitionName, scannerOffset, scannerLength, start);
                token1 = scanner.nextToken();
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.advance();
        while (!this.isEOS()) {
            this.advance();
        }
    }

    private void scanPartition(IDocument document, String partitionName, int startOffset, int length, int offsetToAddToTokens) throws BadLocationException {
        TokenList tl = LanguageRegistry.getTokenList((String)"text/ruby");
        ITokenScanner scanner2 = this.getScanner(partitionName);
        scanner2.setRange(document, startOffset, length);
        IToken token = scanner2.nextToken();
        while (!token.isEOF()) {
            int scannerOffset = scanner2.getTokenOffset();
            int scannerLength = scanner2.getTokenLength();
            Integer integer = (Integer)token.getData();
            int jRubyType = integer;
            int ourType = RubyTokenTypes.getOurTokenType(jRubyType);
            if (ourType > -1) {
                Lexeme lexeme = new Lexeme(tl.get(ourType), document.get(scannerOffset, scannerLength), scannerOffset + offsetToAddToTokens);
                this.lexemeList.add(lexeme);
            }
            token = scanner2.nextToken();
        }
    }

    private ITokenScanner getScanner(String partitionName) {
        if (partitionName.equals("__dftl_partition_content_type")) {
            return new RubyTokenScanner();
        }
        IColorManager colorManager = RubyPlugin.getDefault().getRubyTextTools().getColorManager();
        IPreferenceStore store = RubyPlugin.getDefault().getPreferenceStore();
        if (partitionName.equals("__ruby_multiline_comment")) {
            return new AptanaRubyCommentScanner(colorManager, store, "color_ruby_multiline_comment");
        }
        if (partitionName.equals("__ruby_singleline_comment")) {
            return new AptanaRubyCommentScanner(colorManager, store, "color_ruby_singleline_comment");
        }
        if (partitionName.equals("__ruby_command")) {
            return new AptanaSingleTokenRubyScanner(colorManager, store, "color_ruby_command");
        }
        if (partitionName.equals("__ruby_string")) {
            return new AptanaSingleTokenRubyScanner(colorManager, store, "color_ruby_string");
        }
        if (partitionName.equals("__ruby_regular_expression")) {
            return new AptanaSingleTokenRubyScanner(colorManager, store, "color_ruby_regexp");
        }
        return null;
    }

    protected Lexeme getNextLexemeInLanguage() throws LexerException {
        if (this.index >= this.lexemeList.size()) {
            this.getLexer().setCurrentOffset(this.getLexer().getEOFOffset());
            return null;
        }
        return this.lexemeList.get(this.index++);
    }
}

