/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.osgi.framework.Bundle;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.internal.launching.StandardVMRunner;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMRunner;
import org.rubypeople.rdt.launching.VMRunnerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRubyVMRunner
extends StandardVMRunner
implements IVMRunner {
    private static final String GEM_MEMORY_HACK = "-J-Xmx512M";

    @Override
    protected String[] combineVmArgs(VMRunnerConfiguration configuration, IVMInstall vmInstall) {
        String[] result = this.tryGemMemoryHack(configuration, super.combineVmArgs(configuration, vmInstall));
        result = this.tryRailsRubyPlatformHack(configuration, result);
        return result;
    }

    private String[] tryRailsRubyPlatformHack(VMRunnerConfiguration configuration, String[] old) {
        if (!this.isWindows()) {
            return old;
        }
        String file = configuration.getFileToLaunch();
        if (file.endsWith("script/server")) {
            if (old.length == 0) {
                return new String[]{"-e", "RUBY_PLATFORM='java mswin'", "-e", "load(ARGV.shift)"};
            }
            String[] newArray = new String[old.length + 2];
            System.arraycopy(old, 0, newArray, 0, old.length);
            newArray[old.length - 2] = "-e";
            newArray[old.length - 1] = "RUBY_PLATFORM='java mswin'";
            newArray[old.length] = "-e";
            newArray[old.length + 1] = "load(ARGV.shift)";
            return newArray;
        }
        if (!(file.endsWith("rake") || file.endsWith("script/generate") || file.endsWith("script/plugin") || file.endsWith("script/console") || file.endsWith("script/destroy"))) {
            return old;
        }
        String[] newArray = new String[old.length + 4];
        System.arraycopy(old, 0, newArray, 0, old.length);
        newArray[old.length] = "-e";
        newArray[old.length + 1] = "RUBY_PLATFORM='java mswin'";
        newArray[old.length + 2] = "-e";
        newArray[old.length + 3] = "load(ARGV.shift)";
        return newArray;
    }

    private String[] tryGemMemoryHack(VMRunnerConfiguration configuration, String[] old) {
        if (this.isWindows()) {
            return old;
        }
        String file = configuration.getFileToLaunch();
        if (!file.endsWith("gem")) {
            return old;
        }
        String[] newArray = new String[old.length + 1];
        System.arraycopy(old, 0, newArray, 1, old.length);
        newArray[0] = GEM_MEMORY_HACK;
        return newArray;
    }

    @Override
    protected String getCommand(VMRunnerConfiguration config) {
        String command = super.getCommand(config);
        if (command == null) {
            return null;
        }
        if (command.equals("ruby") || command.equals("rubyw") || command.equals("irb")) {
            return "j" + command;
        }
        return command;
    }

    @Override
    protected List<String> constructProgramString(VMRunnerConfiguration config) throws CoreException {
        if (!this.isWindows()) {
            String installLocation = this.fVMInstance.getInstallLocation().getAbsolutePath();
            File exe = new File(String.valueOf(installLocation) + File.separatorChar + "bin" + File.separatorChar + "jruby");
            if (this.fileExists(exe)) {
                try {
                    Process p = this.setExecutableBit(exe.getAbsolutePath());
                    p.waitFor();
                }
                catch (InterruptedException e) {
                    LaunchingPlugin.log(e);
                }
            }
            try {
                Bundle bundle;
                String link = String.valueOf(installLocation) + File.separator + "lib" + File.separator + "derbyclient.jar";
                File linkFile = new File(link);
                if (!linkFile.exists() && (bundle = Platform.getBundle((String)"com.aptana.ide.libraries")) != null) {
                    URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("derbyclient.jar"), null);
                    url = FileLocator.toFileURL((URL)url);
                    String path = url.getFile();
                    File file = new File(path);
                    Process p = this.createSymbolicLink(file.getAbsolutePath(), link);
                    p.waitFor();
                }
            }
            catch (Exception e) {
                LaunchingPlugin.log(e);
            }
            return super.constructProgramString(config);
        }
        ArrayList<String> string = new ArrayList<String>();
        string.add("java");
        String installLocation = this.fVMInstance.getInstallLocation().getAbsolutePath();
        File exe = new File(String.valueOf(installLocation) + File.separatorChar + "bin" + File.separatorChar + "jruby.bat");
        if (this.fileExists(exe)) {
            File lib = new File(this.fVMInstance.getInstallLocation(), "lib");
            String[] jars = lib.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            String jarString = "";
            int i = 0;
            while (i < jars.length) {
                if (i != 0) {
                    jarString = String.valueOf(jarString) + File.pathSeparator;
                }
                jarString = String.valueOf(jarString) + lib.getAbsolutePath() + File.separator + jars[i];
                ++i;
            }
            try {
                Bundle bundle = Platform.getBundle((String)"com.aptana.ide.libraries");
                if (bundle != null) {
                    URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("derbyclient.jar"), null);
                    url = FileLocator.toFileURL((URL)url);
                    String path = url.getFile();
                    File file = new File(path.substring(1));
                    jarString = String.valueOf(jarString) + File.pathSeparator + file.getAbsolutePath();
                }
            }
            catch (IOException e) {
                LaunchingPlugin.log(e);
            }
            string.add("-Xverify:none");
            if (config.getFileToLaunch().endsWith("gem")) {
                string.add("-Xmx512m");
            } else {
                string.add("-Xmx256m");
            }
            string.add("-Xss1024k");
            string.add("-cp");
            string.add("\"" + jarString + "\"");
            string.add("-Djruby.base=\"" + installLocation + "\"");
            string.add("-Djruby.home=\"" + installLocation + "\"");
            string.add("-Djruby.lib=\"" + lib.getAbsolutePath() + "\"");
            if (this.isWindows()) {
                string.add("-Djruby.shell=\"cmd.exe\"");
            } else {
                string.add("-Djruby.shell=/bin/sh");
            }
            string.add("-Djruby.script=\"" + exe.getName() + "\"");
            string.add("org.jruby.Main");
            return string;
        }
        this.abort(MessageFormat.format(LaunchingMessages.StandardVMRunner_Specified_executable__0__does_not_exist_for__1__4, "jruby.jar", this.fVMInstance.getName()), null, 150);
        return null;
    }

    private boolean isWindows() {
        return Platform.getOS().equals("win32");
    }

    @Override
    protected String[] getEnvironment(VMRunnerConfiguration config) {
        String[] env = super.getEnvironment(config);
        if (env == null) {
            env = new String[]{};
        }
        int itemsToAdd = 4;
        if (this.isWindows()) {
            ++itemsToAdd;
        }
        String[] special = new String[env.length + itemsToAdd];
        System.arraycopy(env, 0, special, 0, env.length);
        special[env.length + 0] = "CLASSPATH=.";
        special[env.length + 1] = "JRUBY_BASE=" + this.fVMInstance.getInstallLocation().getAbsolutePath();
        special[env.length + 2] = "JRUBY_HOME=" + this.fVMInstance.getInstallLocation().getAbsolutePath();
        special[env.length + 3] = "JAVA_HOME=" + System.getProperty("java.home");
        String root = System.getenv("SYSTEMROOT");
        if (root == null || root.trim().length() == 0) {
            root = "C:\\Windows";
        }
        if (this.isWindows()) {
            special[env.length + 4] = "SystemRoot=" + root;
        }
        return special;
    }

    @Override
    protected void addStreamSync(List<String> arguments) {
    }

    @Override
    protected Process exec(String[] cmdLine, File workingDirectory, String[] envp) throws CoreException {
        Process p;
        block3: {
            String cmd = this.getCmdLineAsString(cmdLine);
            LaunchingPlugin.info("Starting: " + cmd);
            p = null;
            try {
                p = this.isWindows() ? (workingDirectory == null ? Runtime.getRuntime().exec(cmd, envp) : Runtime.getRuntime().exec(cmd, envp, workingDirectory)) : (workingDirectory == null ? Runtime.getRuntime().exec(cmdLine, envp) : Runtime.getRuntime().exec(cmdLine, envp, workingDirectory));
            }
            catch (IOException e) {
                Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, LaunchingMessages.DebugPlugin_Exception_occurred_executing_command_line__1, (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            catch (NoSuchMethodError e) {
                Object result;
                Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 115, LaunchingMessages.DebugPlugin_Eclipse_runtime_does_not_support_working_directory_2, (Throwable)e);
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                if (handler == null || !((result = handler.handleStatus((IStatus)status, null)) instanceof Boolean) || !((Boolean)result).booleanValue()) break block3;
                p = this.exec(cmdLine, null);
            }
        }
        return p;
    }

    private Process setExecutableBit(String filePath) {
        LaunchingPlugin.log("Setting executable bit for: " + filePath);
        if (filePath == null) {
            return null;
        }
        try {
            Process pr = Runtime.getRuntime().exec(new String[]{"chmod", "a+x", filePath});
            StreamConsumer chmodOutput = new StreamConsumer(pr.getInputStream());
            chmodOutput.setName("chmod output reader");
            chmodOutput.start();
            StreamConsumer chmodError = new StreamConsumer(pr.getErrorStream());
            chmodError.setName("chmod error reader");
            chmodError.start();
            return pr;
        }
        catch (IOException ioe) {
            LaunchingPlugin.log(ioe);
            return null;
        }
    }

    private Process createSymbolicLink(String target, String linkLocation) {
        LaunchingPlugin.log("Creating symbolic link from: " + linkLocation + " to: " + target);
        if (target == null || linkLocation == null) {
            return null;
        }
        try {
            Process pr = Runtime.getRuntime().exec(new String[]{"ln", "-s", target, linkLocation});
            StreamConsumer chmodOutput = new StreamConsumer(pr.getInputStream());
            chmodOutput.setName("ln -s output reader");
            chmodOutput.start();
            StreamConsumer chmodError = new StreamConsumer(pr.getErrorStream());
            chmodError.setName("ln - error reader");
            chmodError.start();
            return pr;
        }
        catch (IOException ioe) {
            LaunchingPlugin.log(ioe);
            return null;
        }
    }

    public static class StreamConsumer
    extends Thread {
        InputStream is;
        byte[] buf;

        public StreamConsumer(InputStream inputStream) {
            this.setDaemon(true);
            this.is = inputStream;
            this.buf = new byte[512];
        }

        public void run() {
            try {
                int n = 0;
                while (n >= 0) {
                    n = this.is.read(this.buf);
                }
            }
            catch (IOException iOException) {}
        }
    }
}

