/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.rubypeople.rdt.internal.launching.JRubyVM;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.internal.launching.LibraryInfo;
import org.rubypeople.rdt.launching.AbstractVMInstallType;
import org.rubypeople.rdt.launching.IVMInstall;

public class JRubyVMType
extends AbstractVMInstallType {
    private static Map<String, LibraryInfo> fgFailedInstallPath = new HashMap<String, LibraryInfo>();
    private static final char fgSeparator = File.separatorChar;
    private static final String[] fgCandidateRubyFiles = new String[]{"jrubyw", "jrubyw.bat", "jruby", "jruby.bat"};
    private static final String[] fgCandidateRubyLocations = new String[]{"", "bin" + fgSeparator};

    protected IVMInstall doCreateVMInstall(String id) {
        return new JRubyVM(this, id);
    }

    public File detectInstallLocation() {
        File rubyExecutable = null;
        if (Platform.getOS().equals("win32")) {
            String winPath = System.getenv("Path");
            String[] paths = winPath.split(";");
            int i = 0;
            while (i < paths.length) {
                String possibleExecutablePath = String.valueOf(paths[i]) + File.separator + "jruby.bat";
                File possible = new File(possibleExecutablePath);
                if (possible.exists()) {
                    rubyExecutable = possible;
                    break;
                }
                ++i;
            }
        } else {
            String[] cmdLine = new String[]{"which", "jruby"};
            rubyExecutable = this.parseRubyExecutableLocation(this.executeAndRead(cmdLine));
        }
        File location = this.tryLocation(rubyExecutable);
        if (location != null) {
            return location;
        }
        return this.tryIncludedJRuby();
    }

    private File tryIncludedJRuby() {
        try {
            Bundle bundle = Platform.getBundle((String)"org.jruby");
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(""), null);
            url = FileLocator.toFileURL((URL)url);
            String fileName = url.getFile();
            String executable = String.valueOf(fileName) + "bin" + File.separator + "jruby";
            if (Platform.getOS().equals("win32")) {
                executable = String.valueOf(executable) + ".bat";
            }
            return this.tryLocation(new File(executable));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private File tryLocation(File rubyExecutable) {
        if (rubyExecutable == null) {
            return null;
        }
        File bin = rubyExecutable.getParentFile();
        if (!bin.exists()) {
            return null;
        }
        File rubyHome = bin.getParentFile();
        if (!rubyHome.exists()) {
            return null;
        }
        if (!this.canDetectDefaultSystemLibraries(rubyHome, rubyExecutable)) {
            return null;
        }
        return rubyHome;
    }

    public IPath[] getDefaultLibraryLocations(File installLocation) {
        File rubyExecutable = JRubyVMType.findRubyExecutable(installLocation);
        LibraryInfo info = rubyExecutable == null ? this.getDefaultLibraryInfo(installLocation) : this.getLibraryInfo(installLocation, rubyExecutable);
        String[] loadpath = info.getBootpath();
        IPath[] paths = new IPath[loadpath.length];
        int i = 0;
        while (i < loadpath.length) {
            paths[i] = new Path(loadpath[i]);
            ++i;
        }
        return paths;
    }

    public String getName() {
        return "JRuby VM";
    }

    public IStatus validateInstallLocation(File rubyHome) {
        Status status = null;
        File rubyExecutable = JRubyVMType.findRubyExecutable(rubyHome);
        status = rubyExecutable == null ? new Status(4, LaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.StandardVMType_Not_a_JDK_Root__Java_executable_was_not_found_1, null) : (this.canDetectDefaultSystemLibraries(rubyHome, rubyExecutable) ? new Status(0, LaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.StandardVMType_ok_2, null) : new Status(4, LaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.StandardVMType_Not_a_JDK_root__System_library_was_not_found__1, null));
        return status;
    }

    public static File findRubyExecutable(File vmInstallLocation) {
        int i = 0;
        while (i < fgCandidateRubyFiles.length) {
            int j = 0;
            while (j < fgCandidateRubyLocations.length) {
                File rubyFile = new File(vmInstallLocation, String.valueOf(fgCandidateRubyLocations[j]) + fgCandidateRubyFiles[i]);
                if (rubyFile.isFile() && JRubyVMType.isPlatformProper(rubyFile)) {
                    return rubyFile;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private static boolean isPlatformProper(File rubyFile) {
        if (Platform.getOS().equals("win32")) {
            return rubyFile.getName().endsWith(".bat");
        }
        return !rubyFile.getName().endsWith(".bat");
    }

    protected boolean canDetectDefaultSystemLibraries(File rubyHome, File rubyExecutable) {
        IPath[] locations = this.getDefaultLibraryLocations(rubyHome);
        return locations.length > 0;
    }

    protected LibraryInfo getDefaultLibraryInfo(File installLocation) {
        IPath[] dflts = this.getDefaultSystemLibrary(installLocation);
        String[] strings = new String[dflts.length];
        int i = 0;
        while (i < dflts.length) {
            strings[i] = dflts[i].toOSString();
            ++i;
        }
        return new LibraryInfo("1.8.5", strings);
    }

    protected IPath[] getDefaultSystemLibrary(File rubyHome) {
        String stdPath = String.valueOf(rubyHome.getAbsolutePath()) + fgSeparator + "lib" + fgSeparator + "ruby" + fgSeparator + "1.8";
        String sitePath = String.valueOf(rubyHome.getAbsolutePath()) + fgSeparator + "lib" + fgSeparator + "ruby" + fgSeparator + "site_ruby" + fgSeparator + "1.8";
        IPath[] paths = new IPath[]{new Path(sitePath), new Path(stdPath)};
        return paths;
    }

    protected synchronized LibraryInfo getLibraryInfo(File rubyHome, File rubyExecutable) {
        String installPath = rubyHome.getAbsolutePath();
        LibraryInfo info = LaunchingPlugin.getLibraryInfo(this, installPath);
        if (info == null && (info = fgFailedInstallPath.get(installPath)) == null) {
            info = this.generateLibraryInfo(rubyHome, rubyExecutable);
            if (info == null) {
                info = this.getDefaultLibraryInfo(rubyHome);
                fgFailedInstallPath.put(installPath, info);
            } else {
                LaunchingPlugin.setLibraryInfo(this, installPath, info);
            }
        }
        return info;
    }

    public File findExecutable(File installLocation) {
        return JRubyVMType.findRubyExecutable(installLocation);
    }

    public String getVMPlatform(File installLocation, File executable) {
        return "jruby";
    }
}

