/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.rubypeople.rdt.core.ILoadpathContainer;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.LoadpathContainerInitializer;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.launching.RubyVMContainer;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallType;
import org.rubypeople.rdt.launching.RubyRuntime;

public class RubyContainerInitializer
extends LoadpathContainerInitializer {
    public void initialize(IPath containerPath, IRubyProject project) throws CoreException {
        int size = containerPath.segmentCount();
        if (size > 0 && containerPath.segment(0).equals(RubyRuntime.RUBY_CONTAINER)) {
            IVMInstall vm = RubyContainerInitializer.resolveInterpreter(containerPath);
            RubyVMContainer container = null;
            if (vm != null) {
                container = new RubyVMContainer(vm, containerPath);
            }
            RubyCore.setLoadpathContainer((IPath)containerPath, (IRubyProject[])new IRubyProject[]{project}, (ILoadpathContainer[])new ILoadpathContainer[]{container}, null);
        }
    }

    public static IVMInstall resolveInterpreter(IPath containerPath) {
        IVMInstall vm = null;
        if (containerPath.segmentCount() > 1) {
            String vmTypeId = RubyContainerInitializer.getInterpreterTypeId(containerPath);
            String vmName = RubyContainerInitializer.getInterpreterName(containerPath);
            IVMInstallType vmType = RubyRuntime.getVMInstallType(vmTypeId);
            if (vmType != null) {
                vm = vmType.findVMInstallByName(vmName);
            }
        } else {
            vm = RubyRuntime.getDefaultVMInstall();
        }
        return vm;
    }

    public static String getInterpreterTypeId(IPath path) {
        return path.segment(1);
    }

    public static String getInterpreterName(IPath path) {
        return path.segment(2);
    }
}

