/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;

public class RubyLaunchableTester
extends PropertyTester {
    private static final String PROPERTY_HAS_METHOD = "hasMethod";
    private static final String PROPERTY_EXTENDS_CLASS = "extendsClass";
    private static final String PROPERTY_IS_CONTAINER = "isContainer";
    private static final String PROPERTY_PROJECT_NATURE = "hasProjectNature";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IResource resource;
        if (PROPERTY_IS_CONTAINER.equals(property)) {
            IResource resource2;
            if (receiver instanceof IAdaptable && (resource2 = (IResource)((IAdaptable)receiver).getAdapter(IResource.class)) != null) {
                return resource2 instanceof IContainer;
            }
            return false;
        }
        if (PROPERTY_PROJECT_NATURE.equals(property) && receiver instanceof IAdaptable && (resource = (IResource)((IAdaptable)receiver).getAdapter(IResource.class)) != null) {
            return this.hasProjectNature(resource, (String)args[0]);
        }
        IRubyElement element = null;
        if (receiver instanceof IAdaptable && (element = (IRubyElement)((IAdaptable)receiver).getAdapter(IRubyElement.class)) != null && !element.exists()) {
            return false;
        }
        if (PROPERTY_HAS_METHOD.equals(property)) {
            return this.hasMethod(element, args);
        }
        if (PROPERTY_EXTENDS_CLASS.equals(property)) {
            return this.hasSuperclass(element, (String)args[0]);
        }
        if (PROPERTY_PROJECT_NATURE.equals(property)) {
            return this.hasProjectNature(element, (String)args[0]);
        }
        return false;
    }

    private boolean hasProjectNature(IResource resource, String ntype) {
        try {
            if (resource != null) {
                IProject proj = resource.getProject();
                return proj.isAccessible() && proj.hasNature(ntype);
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasMethod(IRubyElement element, Object[] args) {
        try {
            String signature;
            String[] parms;
            String name;
            IMethod candidate;
            IType type;
            if (args.length <= 1 || (type = this.getType(element)) == null || !type.exists() || !(candidate = type.getMethod(name = (String)args[0], parms = (signature = (String)args[1]).split(","))).exists() || args.length <= 2) return false;
            String modifierText = (String)args[2];
            String[] modifiers = modifierText.split(" ");
            int j = 0;
            while (true) {
                if (j >= modifiers.length) {
                    return true;
                }
                String modifier = modifiers[j];
                if (modifier.equals("public") && !candidate.isPublic()) {
                    return false;
                }
                if (modifier.equals("private") && !candidate.isPrivate()) {
                    return false;
                }
                if (modifier.equals("protected") && !candidate.isProtected()) {
                    return false;
                }
                if (modifier.equals("singleton") && !candidate.isSingleton()) {
                    return false;
                }
                ++j;
            }
        }
        catch (RubyModelException rubyModelException) {}
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasSuperclass(IRubyElement element, String qname) {
        try {
            IType type = this.getType(element);
            if (type == null) return false;
            IType[] stypes = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor()).getAllSuperclasses(type);
            int i = 0;
            while (true) {
                if (i >= stypes.length) {
                    return false;
                }
                if (stypes[i].getFullyQualifiedName().equals(qname)) return true;
                if (stypes[i].getElementName().equals(qname)) {
                    return true;
                }
                ++i;
            }
        }
        catch (RubyModelException rubyModelException) {}
        return false;
    }

    private boolean hasProjectNature(IRubyElement element, String ntype) {
        if (element != null) {
            IResource resource = element.getResource();
            if (resource == null) {
                resource = element.getRubyProject().getProject();
            }
            if (resource != null) {
                return this.hasProjectNature(resource, ntype);
            }
        }
        return false;
    }

    private IType getType(IRubyElement element) throws RubyModelException {
        IType type = null;
        if (element instanceof IRubyScript) {
            type = ((IRubyScript)element).findPrimaryType();
        } else if (element instanceof IType) {
            type = (IType)element;
        } else if (element instanceof IMember) {
            type = ((IMember)element).getDeclaringType();
        }
        return type;
    }
}

