/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.rubypeople.rdt.internal.debug.core.RubyDebuggerProxy;
import org.rubypeople.rdt.internal.debug.core.model.IRubyDebugTarget;
import org.rubypeople.rdt.internal.debug.core.model.RubyDebugTarget;
import org.rubypeople.rdt.internal.debug.core.model.RubyProcessingException;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.IVMConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketAttachConnector
implements IVMConnector {
    @Override
    public String getIdentifier() {
        return IRubyLaunchConfigurationConstants.ID_SOCKET_ATTACH_VM_CONNECTOR;
    }

    @Override
    public String getName() {
        return LaunchingMessages.SocketAttachConnector_Standard__Socket_Attach__4;
    }

    protected static void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), code, message, exception));
    }

    @Override
    public void connect(Map<String, Object> arguments, IProgressMonitor monitor, ILaunch launch) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(LaunchingMessages.SocketAttachConnector_Connecting____1, 2);
        subMonitor.subTask(LaunchingMessages.SocketAttachConnector_Configuring_connection____1);
        String portNumberString = (String)arguments.get("port");
        if (portNumberString == null) {
            SocketAttachConnector.abort(LaunchingMessages.SocketAttachConnector_Port_unspecified_for_remote_connection__2, null, 111);
        }
        int port = Integer.parseInt(portNumberString);
        String host = (String)arguments.get("hostname");
        if (host == null) {
            SocketAttachConnector.abort(LaunchingMessages.SocketAttachConnector_Hostname_unspecified_for_remote_connection__4, null, 109);
        }
        subMonitor.worked(1);
        subMonitor.subTask(LaunchingMessages.SocketAttachConnector_Establishing_connection____2);
        try {
            RubyDebugTarget debugTarget = new RubyDebugTarget(launch, host, port);
            RubyDebuggerProxy proxy = new RubyDebuggerProxy((IRubyDebugTarget)debugTarget, true);
            proxy.start();
            launch.addDebugTarget((IDebugTarget)debugTarget);
            subMonitor.worked(1);
            subMonitor.done();
        }
        catch (IOException e) {
            SocketAttachConnector.abort(LaunchingMessages.SocketAttachConnector_Failed_to_connect_to_remote_VM_1, e, 113);
        }
        catch (RubyProcessingException e) {
            SocketAttachConnector.abort(LaunchingMessages.SocketAttachConnector_Failed_to_connect_to_remote_VM_1, e, 113);
        }
    }

    @Override
    public Map<String, Object> getDefaultArguments() throws CoreException {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("hostname", "localhost");
        args.put("port", 1234);
        return args;
    }

    @Override
    public List<String> getArgumentOrder() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("hostname");
        list.add("port");
        return list;
    }
}

