/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.launching;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugPlugin;

public class ExecutionArguments {
    private String fVMArgs;
    private String fProgramArgs;

    public ExecutionArguments(String vmArgs, String programArgs) {
        if (vmArgs == null || programArgs == null) {
            throw new IllegalArgumentException();
        }
        this.fVMArgs = vmArgs;
        this.fProgramArgs = programArgs;
    }

    public String getVMArguments() {
        return this.fVMArgs;
    }

    public String getProgramArguments() {
        return this.fProgramArgs;
    }

    public String[] getVMArgumentsArray() {
        String[] raw = DebugPlugin.parseArguments((String)this.fVMArgs);
        ArrayList<String> modified = new ArrayList<String>();
        int i = 0;
        while (i < raw.length) {
            String arg = raw[i];
            if ((arg.equals("-e") || arg.equals("-X") || arg.equals("-F")) && raw.length > i + 1) {
                modified.add(String.valueOf(arg) + " " + raw[i + 1]);
                ++i;
            } else {
                modified.add(arg);
            }
            ++i;
        }
        return modified.toArray(new String[modified.size()]);
    }

    public String[] getProgramArgumentsArray() {
        return DebugPlugin.parseArguments((String)this.fProgramArgs);
    }
}

