/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.launching;

import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.launching.AbstractRubyLaunchConfigurationDelegate;
import org.rubypeople.rdt.launching.ExecutionArguments;
import org.rubypeople.rdt.launching.IVMRunner;
import org.rubypeople.rdt.launching.VMRunnerConfiguration;

public class RubyLaunchDelegate
extends AbstractRubyLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(MessageFormat.format("{0}...", configuration.getName()), 3);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(LaunchingMessages.JavaLocalApplicationLaunchConfigurationDelegate_Verifying_launch_attributes____1);
        String mainTypeName = this.verifyFileToLaunch(configuration);
        IVMRunner runner = this.getVMRunner(configuration, mode);
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String[] envp = this.getEnvironment(configuration);
        String pgmArgs = this.getProgramArguments(configuration);
        String vmArgs = this.getVMArguments(configuration);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        String[] loadpath = this.getLoadpath(configuration);
        boolean isSudo = this.getIsSudo(configuration);
        String sudoMessage = this.getSudoMessage(configuration);
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(mainTypeName, loadpath);
        runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
        runConfig.setEnvironment(envp);
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        runConfig.setIsSudo(isSudo);
        runConfig.setSudoMessage(sudoMessage);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
        monitor.subTask(LaunchingMessages.JavaLocalApplicationLaunchConfigurationDelegate_Creating_source_locator____2);
        this.setDefaultSourceLocator(launch, configuration);
        Map configAttributes = configuration.getAttributes();
        for (Object key : configAttributes.keySet()) {
            Object value = configAttributes.get(key);
            launch.setAttribute((String)key, value.toString());
        }
        monitor.worked(1);
        runner.run(runConfig, launch, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.done();
    }
}

