/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.IRuntimeLoadpathEntry;
import org.rubypeople.rdt.launching.IRuntimeLoadpathProvider;
import org.rubypeople.rdt.launching.RubyRuntime;

public class StandardLoadpathProvider
implements IRuntimeLoadpathProvider {
    public IRuntimeLoadpathEntry[] computeUnresolvedLoadpath(ILaunchConfiguration configuration) throws CoreException {
        boolean useDefault = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_DEFAULT_LOADPATH, true);
        if (useDefault) {
            IRubyProject proj = RubyRuntime.getRubyProject(configuration);
            IRuntimeLoadpathEntry jreEntry = RubyRuntime.computeRubyVMEntry(configuration);
            if (proj == null) {
                if (jreEntry == null) {
                    return new IRuntimeLoadpathEntry[0];
                }
                return new IRuntimeLoadpathEntry[]{jreEntry};
            }
            IRuntimeLoadpathEntry[] entries = RubyRuntime.computeUnresolvedRuntimeLoadpath(proj);
            IRuntimeLoadpathEntry projEntry = RubyRuntime.computeRubyVMEntry(proj);
            if (jreEntry != null && projEntry != null && !jreEntry.equals(projEntry)) {
                int i = 0;
                while (i < entries.length) {
                    IRuntimeLoadpathEntry entry = entries[i];
                    if (entry.equals(projEntry)) {
                        entries[i] = jreEntry;
                        return entries;
                    }
                    ++i;
                }
            }
            return entries;
        }
        return this.recoverRuntimePath(configuration, IRubyLaunchConfigurationConstants.ATTR_LOADPATH);
    }

    public IRuntimeLoadpathEntry[] resolveLoadpath(IRuntimeLoadpathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        ArrayList<IRuntimeLoadpathEntry> all = new ArrayList<IRuntimeLoadpathEntry>(entries.length);
        int i = 0;
        while (i < entries.length) {
            IRuntimeLoadpathEntry[] resolved = RubyRuntime.resolveRuntimeLoadpathEntry(entries[i], configuration);
            int j = 0;
            while (j < resolved.length) {
                all.add(resolved[j]);
                ++j;
            }
            ++i;
        }
        return all.toArray(new IRuntimeLoadpathEntry[all.size()]);
    }

    protected IRuntimeLoadpathEntry[] recoverRuntimePath(ILaunchConfiguration configuration, String attribute) throws CoreException {
        List entries = configuration.getAttribute(attribute, Collections.EMPTY_LIST);
        IRuntimeLoadpathEntry[] rtes = new IRuntimeLoadpathEntry[entries.size()];
        int i = 0;
        for (String entry : entries) {
            rtes[i] = RubyRuntime.newRuntimeLoadpathEntry(entry);
            ++i;
        }
        return rtes;
    }
}

