/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.launching;

import java.util.Map;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;

public class VMRunnerConfiguration {
    private String fFileToLaunch;
    private String[] fVMArgs;
    private String[] fProgramArgs;
    private String[] fEnvironment;
    private String[] fLoadPath;
    private String fWorkingDirectory;
    private Map fVMSpecificAttributesMap;
    private boolean fResume = true;
    private boolean fIsSudo;
    private String fSudoMessage;
    private static final String[] fgEmpty = new String[0];

    public VMRunnerConfiguration(String fileToLaunch, String[] loadPath) {
        if (fileToLaunch == null) {
            throw new IllegalArgumentException(LaunchingMessages.vmRunnerConfig_assert_classNotNull);
        }
        if (loadPath == null) {
            throw new IllegalArgumentException(LaunchingMessages.vmRunnerConfig_assert_classPathNotNull);
        }
        this.fFileToLaunch = fileToLaunch;
        this.fLoadPath = loadPath;
    }

    public void setVMSpecificAttributesMap(Map map) {
        this.fVMSpecificAttributesMap = map;
    }

    public void setVMArguments(String[] args) {
        if (args == null) {
            throw new IllegalArgumentException(LaunchingMessages.vmRunnerConfig_assert_vmArgsNotNull);
        }
        this.fVMArgs = args;
    }

    public void setProgramArguments(String[] args) {
        if (args == null) {
            throw new IllegalArgumentException(LaunchingMessages.vmRunnerConfig_assert_programArgsNotNull);
        }
        this.fProgramArgs = args;
    }

    public void setEnvironment(String[] environment) {
        this.fEnvironment = environment;
    }

    public Map getVMSpecificAttributesMap() {
        return this.fVMSpecificAttributesMap;
    }

    public String getFileToLaunch() {
        return this.fFileToLaunch;
    }

    public String[] getLoadPath() {
        return this.fLoadPath;
    }

    public String[] getVMArguments() {
        if (this.fVMArgs == null) {
            return fgEmpty;
        }
        return this.fVMArgs;
    }

    public String[] getProgramArguments() {
        if (this.fProgramArgs == null) {
            return fgEmpty;
        }
        return this.fProgramArgs;
    }

    public String[] getEnvironment() {
        return this.fEnvironment;
    }

    public void setWorkingDirectory(String path) {
        this.fWorkingDirectory = path;
    }

    public String getWorkingDirectory() {
        return this.fWorkingDirectory;
    }

    public void setResumeOnStartup(boolean resume) {
        this.fResume = resume;
    }

    public boolean isResumeOnStartup() {
        return this.fResume;
    }

    public void setIsSudo(boolean isSudo) {
        this.fIsSudo = isSudo;
    }

    public boolean isSudo() {
        return this.fIsSudo;
    }

    public void setSudoMessage(String message) {
        this.fSudoMessage = message;
    }

    public String getSudoMessage() {
        if (this.fSudoMessage == null) {
            return "Please enter your local password for running commands under sudo. You are being asked because some commands require access to change protected files and directories on your system.";
        }
        return this.fSudoMessage;
    }
}

