/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.radrails.cloud.shell;

import com.aptana.ide.core.IdeLog;
import com.aptana.radrails.cloud.Activator;
import com.aptana.rdt.AptanaRDTPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.launching.RubyRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ApCloud {
    private IProject fLastProject;
    private Map<String, String> fCachedTasks;

    ApCloud() {
    }

    public Map<String, String> getTasks(IProject project, boolean force) {
        if (!force && this.projectHasntChanged(project) && this.haveCachedTasks()) {
            return this.fCachedTasks;
        }
        this.fLastProject = project;
        this.fCachedTasks = null;
        try {
            BufferedReader bufReader = new BufferedReader(new StringReader(ApCloud.getTasksText(project, ApCloud.getWorkingDirectory(project))));
            Pattern pat = Pattern.compile("^cap\\s+([\\w:]+)\\s+#\\s+(.+)$");
            String line = null;
            HashMap<String, String> tasks = new HashMap<String, String>();
            while ((line = bufReader.readLine()) != null) {
                Matcher mat = pat.matcher(line);
                if (!mat.matches()) continue;
                tasks.put(mat.group(1), mat.group(2));
            }
            if (tasks.isEmpty()) {
                return new HashMap<String, String>();
            }
            this.fCachedTasks = Collections.unmodifiableMap(tasks);
            return this.fCachedTasks;
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (String)"Error parsing rake tasks", (Throwable)e);
            return new HashMap<String, String>();
        }
    }

    private boolean haveCachedTasks() {
        return this.fCachedTasks != null && !this.fCachedTasks.isEmpty();
    }

    private boolean projectHasntChanged(IProject selected) {
        return selected != null && selected.equals((Object)this.fLastProject);
    }

    private static String getTasksText(IProject project, String workingDirectory) {
        block3: {
            String result;
            block4: {
                String rakePath = ApCloud.buildBinExecutablePath("apcloud");
                if (project == null || rakePath == null || rakePath.trim().length() <= 0) break block3;
                ILaunchConfigurationWorkingCopy wc = RubyRuntime.createBasicLaunch((String)rakePath, (String)"-T", (IProject)project, (String)workingDirectory);
                File file = ApCloud.getRakeTasksFile(project);
                result = RubyRuntime.launchInBackgroundAndRead((ILaunchConfiguration)wc.doSave(), (File)file);
                if (result != null) break block4;
                return "";
            }
            try {
                return result;
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)Activator.getDefault(), (String)"Error listing apcloud tasks", (Throwable)e);
            }
        }
        return "";
    }

    private static File getRakeTasksFile(IProject proj) {
        File file = Activator.getDefault().getStateLocation().append("apcloud").append(String.valueOf(proj.getName()) + "_tasks.txt").toFile();
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        catch (IOException iOException) {}
        return file;
    }

    private static String getWorkingDirectory(IProject project) {
        if (project == null) {
            return null;
        }
        try {
            CapfileFinder finder = new CapfileFinder();
            project.accept((IResourceProxyVisitor)finder, 2);
            File workingDir = finder.getWorkingDirectory();
            if (workingDir != null) {
                return workingDir.getAbsolutePath();
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (String)e.getMessage(), (Throwable)e);
        }
        return project.getLocation().toOSString();
    }

    private static String buildBinExecutablePath(String command) {
        IPath path = RubyRuntime.checkInterpreterBin((String)command);
        if (path != null && path.toFile().exists()) {
            return path.toOSString();
        }
        path = AptanaRDTPlugin.checkBinDir((String)command);
        if (path != null && path.toFile().exists()) {
            return path.toOSString();
        }
        path = RubyCore.checkSystemPath((String)command);
        if (path != null && path.toFile().exists()) {
            return path.toOSString();
        }
        return null;
    }

    private static class CapfileFinder
    implements IResourceProxyVisitor {
        private static final String CAPFILE = "Capfile";
        private File workingDirectory;

        private CapfileFinder() {
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            IPath path;
            if (proxy.getType() == 1 && (path = proxy.requestFullPath()).lastSegment().equalsIgnoreCase(CAPFILE)) {
                this.workingDirectory = path.removeLastSegments(1).toFile();
            }
            return this.workingDirectory == null && (proxy.getType() == 2 || proxy.getType() == 4 || proxy.getType() == 8);
        }

        public File getWorkingDirectory() {
            return this.workingDirectory;
        }
    }
}

