/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.radrails.cloud.shell;

import com.aptana.ide.server.cloud.services.model.studio.SiteUtils;
import com.aptana.ide.server.cloud.services.model.studio.StudioSite;
import com.aptana.radrails.cloud.internal.CloudUtil;
import com.aptana.radrails.cloud.shell.ApCloud;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.radrails.rails.ui.console.RailsShellCommandProvider;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.ITerminal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AptanaCloudCommandProvider
extends RailsShellCommandProvider {
    static final String LIST_TASKS_SWITCH = "-T";
    public static final String APCLOUD = "apcloud";
    public static final String APCLOUDIFY = "apcloudify";
    public static final String STAGING = "staging";
    public static final String PUBLIC = "public";
    public static final String CLOUD_SETUP = "cloud:setup";
    public static final String APTANA_DEPLOY = "cloud:deploy";

    public Set<String> commandsHandled() {
        HashSet<String> commands = new HashSet<String>();
        commands.add(APCLOUD);
        commands.add(APCLOUDIFY);
        return commands;
    }

    public List<ICompletionProposal> getCompletionProposals(String prefix, List<String> tokens, int offset) {
        Map<String, String> tasks;
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String token = this.getLastToken(prefix, tokens);
        if (tokens.isEmpty() || tokens.size() == 1 && !prefix.endsWith(" ")) {
            proposals.add(this.createProposal(APCLOUDIFY, "Runs a script to set your rails project up to deploy to the Aptana Cloud", offset, token));
            proposals.add(this.createProposal(APCLOUD, "Runs commands to deploy your rails project to the Aptana Cloud", offset, token));
            return proposals;
        }
        if (tokens.contains(APCLOUD) && !this.containsArg(tokens, (tasks = new ApCloud().getTasks(this.getProject(), false)).keySet()) && !tokens.contains(LIST_TASKS_SWITCH)) {
            if (!tokens.contains(PUBLIC) && !tokens.contains(STAGING)) {
                for (Map.Entry<String, String> entry : tasks.entrySet()) {
                    if (entry.getKey().contains("deploy")) continue;
                    proposals.add(this.createProposal(entry.getKey(), entry.getValue(), offset, token));
                }
                proposals.add(this.createProposal(LIST_TASKS_SWITCH, "List all the available tasks", offset, token));
            } else {
                for (Map.Entry<String, String> entry : tasks.entrySet()) {
                    if (!entry.getKey().contains("deploy")) continue;
                    proposals.add(this.createProposal(entry.getKey(), entry.getValue(), offset, token));
                }
            }
        }
        return proposals;
    }

    private boolean containsArg(List<String> tokens, Set<String> tasks) {
        for (String token : tokens) {
            for (String task : tasks) {
                if (task.equalsIgnoreCase(PUBLIC) || task.equalsIgnoreCase(STAGING) || !token.equals(task)) continue;
                return true;
            }
        }
        return false;
    }

    public void run(ITerminal shell, String command) {
        if (!command.startsWith(APCLOUDIFY) && !command.startsWith(APCLOUD)) {
            return;
        }
        IStatus result = CloudUtil.installCloudGemIfNecessary(null);
        if (!result.isOK()) {
            return;
        }
        if (command.startsWith(APCLOUDIFY)) {
            this.launchApCloudify(shell, command);
        } else if (command.startsWith(APCLOUD)) {
            this.launchInsideShell(shell, command, this.getEnvMap());
        }
    }

    private void launchApCloudify(ITerminal shell, String command) {
        if (command.trim().length() > APCLOUDIFY.length()) {
            String path = command.trim().substring(APCLOUDIFY.length()).trim();
            if (path.equals(".")) {
                IProject project = this.getProject();
                this.launchInsideShell(shell, "apcloudify " + project.getLocation().toOSString(), this.getEnvMap(), this.refreshAttrMap());
                return;
            }
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path);
            if (project != null && project.exists()) {
                this.launchInsideShell(shell, "apcloudify " + project.getLocation().toOSString(), this.getEnvMap(), this.refreshAttrMap());
                shell.setProject(project);
                return;
            }
            this.launchInsideShell(shell, command, this.getEnvMap());
            return;
        }
        IProject project = this.getProject();
        this.launchInsideShell(shell, "apcloudify " + project.getLocation().toOSString(), this.getEnvMap(), this.refreshAttrMap());
    }

    private Map<String, Object> refreshAttrMap() {
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        attrMap.put(IRubyLaunchConfigurationConstants.ATTR_REQUIRES_REFRESH, true);
        return attrMap;
    }

    private Map<String, String> getEnvMap() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        StudioSite site = SiteUtils.getSite((IProject)project);
        return CloudUtil.getEnvMap(site);
    }
}

