/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.core.builder;

import com.aptana.rdt.AptanaRDTPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.jruby.ast.FCallNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.compiler.BuildContext;
import org.rubypeople.rdt.core.compiler.CompilationParticipant;
import org.rubypeople.rdt.internal.core.parser.InOrderVisitor;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.core.util.ASTUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemLoadpathAdder
extends CompilationParticipant {
    private IRubyProject project;

    public int aboutToBuild(IRubyProject project) {
        this.project = project;
        return super.aboutToBuild(project);
    }

    public void buildStarting(BuildContext[] files, boolean isBatch) {
        RubyParser parser = new RubyParser();
        int i = 0;
        while (i < files.length) {
            List<ILoadpathEntry> newEntries;
            Collection<String> gems = this.getGemNames(parser, files[i]);
            if (!gems.isEmpty() && !(newEntries = this.getGemEntries(gems)).isEmpty()) {
                try {
                    this.addNewEntriesToProjectLoadpath(newEntries);
                }
                catch (RubyModelException e) {
                    AptanaRDTPlugin.log(e);
                }
            }
            ++i;
        }
    }

    private void addNewEntriesToProjectLoadpath(List<ILoadpathEntry> newEntries) throws RubyModelException {
        ILoadpathEntry[] raw = this.project.getRawLoadpath();
        ArrayList<ILoadpathEntry> finalEntries = new ArrayList<ILoadpathEntry>();
        finalEntries.addAll((Collection)Arrays.asList(raw));
        for (ILoadpathEntry entry : newEntries) {
            if (this.alreadyContains(raw, entry)) continue;
            finalEntries.add(entry);
        }
        if (finalEntries.size() == raw.length) {
            return;
        }
        this.project.setRawLoadpath(finalEntries.toArray(new ILoadpathEntry[finalEntries.size()]), null);
    }

    private boolean alreadyContains(ILoadpathEntry[] raw, ILoadpathEntry entry) {
        int i = 0;
        while (i < raw.length) {
            if (raw[i].getPath().equals((Object)entry.getPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private List<ILoadpathEntry> getGemEntries(Collection<String> gemNames) {
        ArrayList<ILoadpathEntry> entries = new ArrayList<ILoadpathEntry>();
        for (String gemName : gemNames) {
            IPath gem = AptanaRDTPlugin.findGem(gemName);
            if (gem == null) continue;
            entries.add(RubyCore.newVariableEntry((IPath)gem));
        }
        return entries;
    }

    private Collection<String> getGemNames(RubyParser parser, BuildContext context) {
        try {
            char[] contents = context.getContents();
            Node root = parser.parse(new String(contents));
            GemVisitor visitor = new GemVisitor();
            root.accept((NodeVisitor)visitor);
            return visitor.getGems();
        }
        catch (RuntimeException e) {
            RubyCore.log((Exception)e);
            return Collections.emptyList();
        }
    }

    public boolean isActive(IRubyProject project) {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GemVisitor
    extends InOrderVisitor {
        private Set<String> gems = new HashSet<String>();

        public Instruction visitFCallNode(FCallNode iVisited) {
            List args;
            String name = iVisited.getName();
            if ((name.equals("gem") || name.equals("require_gem")) && (args = ASTUtil.getArgumentsFromFunctionCall((IArgumentNode)iVisited)) != null && !args.isEmpty()) {
                String gemName = (String)args.get(0);
                if (gemName.startsWith("\"") || gemName.startsWith("'")) {
                    gemName = gemName.substring(1, gemName.length() - 1);
                }
                this.gems.add(gemName);
            }
            return super.visitFCallNode(iVisited);
        }

        public Collection<String> getGems() {
            return this.gems;
        }
    }
}

