/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.core.gems;

import com.aptana.rdt.core.gems.Gem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemParser {
    public Set<Gem> parse(String string) {
        if (string == null || string.trim().length() == 0) {
            return new HashSet<Gem>();
        }
        String[] raw = string.split("\n");
        ArrayList<String> lines = new ArrayList<String>((Collection)Arrays.asList(raw));
        if (lines.size() < 2) {
            return new HashSet<Gem>();
        }
        lines.remove(0);
        lines.remove(0);
        lines.remove(0);
        return this.parseOutGems(lines);
    }

    public Set<Gem> parseOutGems(List<String> lines) {
        HashSet<Gem> gems = new HashSet<Gem>();
        int i = 0;
        while (i < lines.size()) {
            String nextLine;
            String nameAndVersion = lines.get(i);
            String description = "";
            if (i + 1 < lines.size()) {
                description = lines.get(i + 1);
            }
            int j = 2;
            while (i + j < lines.size() && (nextLine = lines.get(i + j)).trim().length() != 0) {
                description = String.valueOf(description) + " " + nextLine.trim();
                ++j;
            }
            int openParen = nameAndVersion.indexOf(40);
            int closeParen = nameAndVersion.indexOf(41);
            String name = nameAndVersion.substring(0, openParen);
            String version = nameAndVersion.substring(openParen + 1, closeParen);
            gems.add(new Gem(name.trim(), version, description.trim()));
            i += j + 1;
        }
        return gems;
    }
}

