/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import java.util.HashMap;
import java.util.Map;

public class LintOptions {
    public static final long UnusedPrivateMember = 4L;
    public static final long UnusedArgument = 16L;
    public static final long UnnecessaryElse = 64L;
    public static final long SimilarVariableNames = 256L;
    public static final long MisspelledConstructor = 512L;
    public static final long PossibleAccidentalBooleanAssignment = 1024L;
    public static final long LocalVariableMasksMethod = 2048L;
    public static final long MaxLocals = 4096L;
    public static final long MaxReturns = 8192L;
    public static final long MaxLines = 16384L;
    public static final long MaxBranches = 32768L;
    public static final long MaxArguments = 65536L;
    public static final long UnreachableCode = 131072L;
    public static final long ComparableMissingMethod = 262144L;
    public static final long EnumerableMissingMethod = 524288L;
    public static final long SubclassDoesntCallSuper = 0x100000L;
    public static final long AssignmentPrecedence = 0x200000L;
    public static final long MethodMissingWithoutRespondTo = 0x400000L;
    public static final long ConstantNamingConvention = 0x800000L;
    public static final long DynamicVariableAliasesLocal = 0x1000000L;
    public static final long LocalVariablePossibleAttributeAccess = 0x2000000L;
    public static final long LocalMethodNamingConvention = 0x4000000L;
    public static final long UnusedLocalVariable = 0x8000000L;
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    public static final String IGNORE = "ignore";
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public long errorThreshold = 0L;
    public long warningThreshold = 192024068L;
    public int maxLocals = 5;
    public int maxLines = 50;
    public int maxBranches = 10;
    public int maxReturns = 10;
    public int maxArguments = 10;

    public Map getMap() {
        HashMap<String, String> optionsMap = new HashMap<String, String>(30);
        optionsMap.put("com.aptana.rdt.compiler.problem.unusedPrivateMember", this.getSeverityString(4L));
        optionsMap.put("com.aptana.rdt.compiler.problem.unusedLocalVariable", this.getSeverityString(0x8000000L));
        optionsMap.put("com.aptana.rdt.compiler.problem.subclassDoesntCallSuper", this.getSeverityString(0x100000L));
        optionsMap.put("com.aptana.rdt.compiler.problem.assignmentPrecedence", this.getSeverityString(0x200000L));
        optionsMap.put("com.aptana.rdt.compiler.problem.unusedParameter", this.getSeverityString(16L));
        optionsMap.put("com.aptana.rdt.compiler.problem.unnecessaryElse", this.getSeverityString(64L));
        optionsMap.put("com.aptana.rdt.compiler.problem.misspelledConstructor", this.getSeverityString(512L));
        optionsMap.put("com.aptana.rdt.compiler.problem.possibleAccidentalBooleanAssignment", this.getSeverityString(1024L));
        optionsMap.put("com.aptana.rdt.compiler.problem.localVariableMasksMethod", this.getSeverityString(2048L));
        optionsMap.put("com.aptana.rdt.compiler.problem.codeComplexityArguments", this.getSeverityString(65536L));
        optionsMap.put("com.aptana.rdt.compiler.problem.codeComplexityBranches", this.getSeverityString(32768L));
        optionsMap.put("com.aptana.rdt.compiler.problem.codeComplexityLines", this.getSeverityString(16384L));
        optionsMap.put("com.aptana.rdt.compiler.problem.codeComplexityLocals", this.getSeverityString(4096L));
        optionsMap.put("com.aptana.rdt.compiler.problem.codeComplexityReturns", this.getSeverityString(8192L));
        optionsMap.put("com.aptana.rdt.compiler.problem.similarVariableNames", this.getSeverityString(256L));
        optionsMap.put("com.aptana.rdt.compiler.problem.unreachableCode", this.getSeverityString(131072L));
        optionsMap.put("com.aptana.rdt.compiler.problem.comparableMissingMethod", this.getSeverityString(262144L));
        optionsMap.put("com.aptana.rdt.compiler.problem.enumerableMissingMethod", this.getSeverityString(524288L));
        optionsMap.put("com.aptana.rdt.compiler.problem.constantNamingConvention", this.getSeverityString(0x800000L));
        optionsMap.put("com.aptana.rdt.compiler.problem.methodMissingWithoutRespondTo", this.getSeverityString(0x400000L));
        optionsMap.put("com.aptana.rdt.compiler.problem.dynamicVariableAliasesLocal", this.getSeverityString(0x1000000L));
        optionsMap.put("com.aptana.rdt.compiler.problem.localVariablePossibleAttributeAccess", this.getSeverityString(0x2000000L));
        optionsMap.put("com.aptana.rdt.compiler.problem.methodOrLocalNamingConvention", this.getSeverityString(0x4000000L));
        optionsMap.put("com.aptana.rdt.compiler.problem.maxArguments", String.valueOf(this.maxArguments));
        optionsMap.put("com.aptana.rdt.compiler.problem.maxLines", String.valueOf(this.maxLines));
        optionsMap.put("com.aptana.rdt.compiler.problem.maxLocals", String.valueOf(this.maxLocals));
        optionsMap.put("com.aptana.rdt.compiler.problem.maxReturns", String.valueOf(this.maxReturns));
        optionsMap.put("com.aptana.rdt.compiler.problem.maxBranches", String.valueOf(this.maxBranches));
        return optionsMap;
    }

    public String getSeverityString(long irritant) {
        if ((this.warningThreshold & irritant) != 0L) {
            return WARNING;
        }
        if ((this.errorThreshold & irritant) != 0L) {
            return ERROR;
        }
        return IGNORE;
    }

    public void set(Map optionsMap) {
        int val;
        String stringValue;
        Object optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.unusedPrivateMember");
        if (optionValue != null) {
            this.updateSeverity(4L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.unusedLocalVariable")) != null) {
            this.updateSeverity(0x8000000L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.unusedParameter")) != null) {
            this.updateSeverity(16L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.unnecessaryElse")) != null) {
            this.updateSeverity(64L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.misspelledConstructor")) != null) {
            this.updateSeverity(512L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.possibleAccidentalBooleanAssignment")) != null) {
            this.updateSeverity(1024L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.localVariableMasksMethod")) != null) {
            this.updateSeverity(2048L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.codeComplexityArguments")) != null) {
            this.updateSeverity(65536L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.codeComplexityBranches")) != null) {
            this.updateSeverity(32768L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.codeComplexityLines")) != null) {
            this.updateSeverity(16384L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.codeComplexityLocals")) != null) {
            this.updateSeverity(4096L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.codeComplexityReturns")) != null) {
            this.updateSeverity(8192L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.similarVariableNames")) != null) {
            this.updateSeverity(256L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.unreachableCode")) != null) {
            this.updateSeverity(131072L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.comparableMissingMethod")) != null) {
            this.updateSeverity(262144L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.enumerableMissingMethod")) != null) {
            this.updateSeverity(524288L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.subclassDoesntCallSuper")) != null) {
            this.updateSeverity(0x100000L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.assignmentPrecedence")) != null) {
            this.updateSeverity(0x200000L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.constantNamingConvention")) != null) {
            this.updateSeverity(0x800000L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.methodMissingWithoutRespondTo")) != null) {
            this.updateSeverity(0x400000L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.dynamicVariableAliasesLocal")) != null) {
            this.updateSeverity(0x1000000L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.localVariablePossibleAttributeAccess")) != null) {
            this.updateSeverity(0x2000000L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.methodOrLocalNamingConvention")) != null) {
            this.updateSeverity(0x4000000L, optionValue);
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.maxLocals")) != null && optionValue instanceof String) {
            stringValue = (String)optionValue;
            try {
                val = Integer.parseInt(stringValue);
                if (val >= 0) {
                    this.maxLocals = val;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.maxLines")) != null && optionValue instanceof String) {
            stringValue = (String)optionValue;
            try {
                val = Integer.parseInt(stringValue);
                if (val >= 0) {
                    this.maxLines = val;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.maxBranches")) != null && optionValue instanceof String) {
            stringValue = (String)optionValue;
            try {
                val = Integer.parseInt(stringValue);
                if (val >= 0) {
                    this.maxBranches = val;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.maxArguments")) != null && optionValue instanceof String) {
            stringValue = (String)optionValue;
            try {
                val = Integer.parseInt(stringValue);
                if (val >= 0) {
                    this.maxArguments = val;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((optionValue = optionsMap.get("com.aptana.rdt.compiler.problem.maxReturns")) != null && optionValue instanceof String) {
            stringValue = (String)optionValue;
            try {
                val = Integer.parseInt(stringValue);
                if (val >= 0) {
                    this.maxReturns = val;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    void updateSeverity(long irritant, Object severityString) {
        if (ERROR.equals(severityString)) {
            this.errorThreshold |= irritant;
            this.warningThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
        } else if (WARNING.equals(severityString)) {
            this.errorThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
            this.warningThreshold |= irritant;
        } else if (IGNORE.equals(severityString)) {
            this.errorThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
            this.warningThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }
}

