/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import java.util.Map;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.Node;
import org.jruby.evaluator.Instruction;
import org.jruby.parser.StaticScope;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;
import org.rubypeople.rdt.internal.core.util.ASTUtil;

public class TooManyArgumentsVisitor
extends RubyLintVisitor {
    private int maxArgLength = this.getInt("com.aptana.rdt.compiler.problem.maxArguments", 5);

    public TooManyArgumentsVisitor(String contents) {
        this(AptanaRDTPlugin.getDefault().getOptions(), contents);
    }

    public TooManyArgumentsVisitor(Map options, String contents) {
        super(options, contents);
    }

    private int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt((String)this.fOptions.get(key));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.codeComplexityArguments";
    }

    public Instruction visitDefsNode(DefsNode iVisited) {
        String[] args = ASTUtil.getArgs((Node)iVisited.getArgsNode(), (StaticScope)iVisited.getScope());
        if (args != null && args.length > this.maxArgLength) {
            this.createProblem(iVisited.getArgsNode().getPosition(), "Too many method arguments: " + args.length);
        }
        return super.visitDefsNode(iVisited);
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        String[] args = ASTUtil.getArgs((Node)iVisited.getArgsNode(), (StaticScope)iVisited.getScope());
        if (args != null && args.length > this.maxArgLength) {
            this.createProblem(iVisited.getArgsNode().getPosition(), "Too many method arguments: " + args.length);
        }
        return super.visitDefnNode(iVisited);
    }
}

