/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import java.util.Map;
import org.jruby.ast.CaseNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.Node;
import org.jruby.ast.WhenNode;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;

public class TooManyBranchesVisitor
extends RubyLintVisitor {
    private int maxBranches = this.getInt("com.aptana.rdt.compiler.problem.maxBranches", 5);
    private int branchCount = 0;

    public TooManyBranchesVisitor(String contents) {
        this(AptanaRDTPlugin.getDefault().getOptions(), contents);
    }

    public TooManyBranchesVisitor(Map options, String contents) {
        super(options, contents);
    }

    private int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt((String)this.fOptions.get(key));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.codeComplexityBranches";
    }

    public Instruction visitDefsNode(DefsNode iVisited) {
        this.branchCount = 0;
        return super.visitDefsNode(iVisited);
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        this.branchCount = 0;
        return super.visitDefnNode(iVisited);
    }

    public Instruction visitIfNode(IfNode iVisited) {
        if (iVisited.getThenBody() != null) {
            ++this.branchCount;
        }
        if (iVisited.getElseBody() != null) {
            ++this.branchCount;
        }
        return super.visitIfNode(iVisited);
    }

    public Instruction visitCaseNode(CaseNode iVisited) {
        Object when = (WhenNode)iVisited.getFirstWhenNode();
        while (when != null) {
            ++this.branchCount;
            Node thing = when.getNextCase();
            when = thing instanceof WhenNode ? (WhenNode)when.getNextCase() : null;
        }
        return super.visitCaseNode(iVisited);
    }

    public void exitDefnNode(DefnNode iVisited) {
        if (this.branchCount > this.maxBranches) {
            this.createProblem(iVisited.getNameNode().getPosition(), "Too many branches: " + this.branchCount);
        }
        this.branchCount = 0;
    }

    public void exitDefsNode(DefsNode iVisited) {
        if (this.branchCount > this.maxBranches) {
            this.createProblem(iVisited.getNameNode().getPosition(), "Too many branches: " + this.branchCount);
        }
        this.branchCount = 0;
        super.exitDefsNode(iVisited);
    }
}

