/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.RootNode;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;

public class TooManyLocalsVisitor
extends RubyLintVisitor {
    private int maxLocals = this.getInt("com.aptana.rdt.compiler.problem.maxLocals", 4);
    private Set locals;

    public TooManyLocalsVisitor(String contents) {
        this(AptanaRDTPlugin.getDefault().getOptions(), contents);
    }

    public TooManyLocalsVisitor(Map options, String contents) {
        super(options, contents);
    }

    private int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt((String)this.fOptions.get(key));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.codeComplexityLocals";
    }

    public Instruction visitRootNode(RootNode iVisited) {
        this.locals = new HashSet();
        Instruction ins = super.visitRootNode(iVisited);
        this.locals.clear();
        return ins;
    }

    public Instruction visitDefsNode(DefsNode iVisited) {
        this.locals = new HashSet();
        return super.visitDefsNode(iVisited);
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        this.locals = new HashSet();
        return super.visitDefnNode(iVisited);
    }

    public Instruction visitLocalAsgnNode(LocalAsgnNode iVisited) {
        this.locals.add(iVisited.getName());
        return super.visitLocalAsgnNode(iVisited);
    }

    public void exitDefnNode(DefnNode iVisited) {
        if (this.locals.size() > this.maxLocals) {
            this.createProblem(iVisited.getNameNode().getPosition(), "Too many local variables: " + this.locals.size());
        }
        this.locals.clear();
    }

    public void exitDefsNode(DefsNode iVisited) {
        if (this.locals.size() > this.maxLocals) {
            this.createProblem(iVisited.getNameNode().getPosition(), "Too many local variables: " + this.locals.size());
        }
        this.locals.clear();
        super.exitDefsNode(iVisited);
    }
}

