/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;

public class UnusedLocalVariable
extends RubyLintVisitor {
    private List<LocalAsgnNode> locals = new ArrayList<LocalAsgnNode>();
    private Set<String> refs = new HashSet<String>();

    public UnusedLocalVariable(String contents) {
        super(AptanaRDTPlugin.getDefault().getOptions(), contents);
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.unusedLocalVariable";
    }

    protected int getProblemID() {
        return 603979894;
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        this.clear();
        return super.visitDefnNode(iVisited);
    }

    public Instruction visitDefsNode(DefsNode iVisited) {
        this.clear();
        return super.visitDefsNode(iVisited);
    }

    public Instruction visitLocalAsgnNode(LocalAsgnNode iVisited) {
        this.locals.add(iVisited);
        return super.visitLocalAsgnNode(iVisited);
    }

    public Instruction visitLocalVarNode(LocalVarNode iVisited) {
        this.refs.add(iVisited.getName());
        return super.visitLocalVarNode(iVisited);
    }

    public void exitDefnNode(DefnNode iVisited) {
        this.checkLocals();
        this.clear();
        super.exitDefnNode(iVisited);
    }

    public void exitDefsNode(DefsNode iVisited) {
        this.checkLocals();
        this.clear();
        super.exitDefsNode(iVisited);
    }

    private void clear() {
        this.locals.clear();
        this.refs.clear();
    }

    private void checkLocals() {
        for (LocalAsgnNode local : this.locals) {
            if (this.refs.contains(local.getName())) continue;
            this.createProblem(local.getPosition(), "Unused local variable " + local.getName());
        }
    }
}

