/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.ui.actions;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.core.gems.GemListener;
import com.aptana.rdt.ui.gems.InstallGemDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.UIJob;

public class InstallGemActionDelegate
implements IObjectActionDelegate,
IViewActionDelegate,
GemListener {
    private IAction action;

    public InstallGemActionDelegate() {
        AptanaRDTPlugin.getDefault().getGemManager().addGemListener((GemListener)this);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.action = action;
    }

    public void run(IAction action) {
        InstallGemDialog dialog = new InstallGemDialog(Display.getCurrent().getActiveShell());
        if (dialog.open() == 0) {
            final Gem gem = dialog.getGem();
            final String sourceURL = dialog.getSourceURL();
            UIJob job = new UIJob("Installing gem " + gem.getName()){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    AptanaRDTPlugin.getDefault().getGemManager().installGem(gem, sourceURL);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.action = action;
        action.setEnabled(this.isEnabled());
    }

    private boolean isEnabled() {
        return !AptanaRDTPlugin.getDefault().getGemManager().getRemoteGems().isEmpty();
    }

    public void init(IViewPart view) {
    }

    public void gemAdded(Gem gem) {
    }

    public void gemRemoved(Gem gem) {
    }

    public void gemsRefreshed() {
    }

    public void managerInitialized() {
        if (this.action == null) {
            return;
        }
        this.action.setEnabled(this.isEnabled());
    }
}

