/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.ui.gems;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.core.gems.GemListener;
import com.aptana.rdt.ui.gems.GemContentProvider;
import com.aptana.rdt.ui.gems.GemLabelProvider;
import com.aptana.rdt.ui.gems.GemsMessages;
import com.aptana.rdt.ui.gems.RemoveGemDialog;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.ViewPart;
import org.rubypeople.rdt.ui.TableViewerSorter;

public class GemsView
extends ViewPart
implements GemListener {
    private TableViewer gemViewer;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.gemViewer = new TableViewer(parent, 65540);
        final Table gemTable = this.gemViewer.getTable();
        gemTable.setHeaderVisible(true);
        gemTable.setLinesVisible(false);
        gemTable.setLayoutData((Object)new GridData(1808));
        gemTable.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    TableItem item = gemTable.getItem(gemTable.getSelectionIndex());
                    Gem gem = (Gem)item.getData();
                    if (MessageDialog.openConfirm((Shell)gemTable.getShell(), null, (String)GemsMessages.bind((String)GemsMessages.RemoveGemDialog_msg, (Object)gem.getName()))) {
                        if (gem.hasMultipleVersions()) {
                            RemoveGemDialog dialog = new RemoveGemDialog(Display.getDefault().getActiveShell(), gem.versions());
                            if (dialog.open() == 0) {
                                AptanaRDTPlugin.getDefault().getGemManager().removeGem(new Gem(gem.getName(), dialog.getVersion(), gem.getDescription()));
                            }
                        } else {
                            AptanaRDTPlugin.getDefault().getGemManager().removeGem(gem);
                        }
                    }
                }
            }
        });
        TableColumn nameColumn = new TableColumn(gemTable, 16384);
        nameColumn.setText(GemsMessages.GemsView_NameColumn_label);
        nameColumn.setWidth(150);
        TableColumn versionColumn = new TableColumn(gemTable, 16384);
        versionColumn.setText(GemsMessages.GemsView_VersionColumn_label);
        versionColumn.setWidth(75);
        TableColumn descriptionColumn = new TableColumn(gemTable, 16384);
        descriptionColumn.setText(GemsMessages.GemsView_DescriptionColumn_label);
        descriptionColumn.setWidth(275);
        this.gemViewer.setLabelProvider((IBaseLabelProvider)new GemLabelProvider());
        this.gemViewer.setContentProvider((IContentProvider)new GemContentProvider());
        TableViewerSorter.bind((TableViewer)this.gemViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.gemViewer);
        this.gemViewer.setInput((Object)AptanaRDTPlugin.getDefault().getGemManager().getGems());
        this.createPopupMenu();
        AptanaRDTPlugin.getDefault().getGemManager().addGemListener((GemListener)this);
    }

    public void dispose() {
        AptanaRDTPlugin.getDefault().getGemManager().removeGemListener((GemListener)this);
        super.dispose();
    }

    public void setFocus() {
        this.gemViewer.getTable().setFocus();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IContributionItem[] items = GemsView.this.getViewSite().getActionBars().getToolBarManager().getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i] instanceof ActionContributionItem) {
                        ActionContributionItem aci = (ActionContributionItem)items[i];
                        manager.add(aci.getAction());
                    }
                    ++i;
                }
            }
        });
        menuMgr.add((IContributionItem)new Separator("additions"));
        Menu menu = menuMgr.createContextMenu(this.gemViewer.getControl());
        this.gemViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.gemViewer);
    }

    public void gemsRefreshed() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GemsView.this.gemViewer.setInput((Object)AptanaRDTPlugin.getDefault().getGemManager().getGems());
                GemsView.this.gemViewer.refresh();
            }
        });
    }

    public void gemAdded(Gem gem) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GemsView.this.gemViewer.setInput((Object)AptanaRDTPlugin.getDefault().getGemManager().getGems());
            }
        });
    }

    public void gemRemoved(Gem gem) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GemsView.this.gemViewer.setInput((Object)AptanaRDTPlugin.getDefault().getGemManager().getGems());
            }
        });
    }

    public void managerInitialized() {
    }
}

