/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.mylyn.internal.ruby.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextListener;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LandmarkMarkerManager
implements IInteractionContextListener {
    private static final String ID_MARKER_LANDMARK = "org.eclipse.mylyn.context.ui.markers.landmark";
    private Map<IInteractionElement, Long> markerMap = new HashMap<IInteractionElement, Long>();

    public void contextActivated(IInteractionContext taskscape) {
        this.modelUpdated();
    }

    public void contextDeactivated(IInteractionContext taskscape) {
        this.modelUpdated();
    }

    public void contextCleared(IInteractionContext context) {
        this.modelUpdated();
    }

    private void modelUpdated() {
        try {
            for (IInteractionElement node : this.markerMap.keySet()) {
                this.landmarkRemoved(node);
            }
            this.markerMap.clear();
            for (IInteractionElement node : ContextCorePlugin.getContextManager().getActiveLandmarks()) {
                this.landmarkAdded(node);
            }
        }
        catch (Throwable t) {
            StatusHandler.fail((Throwable)t, (String)"Could not update landmark markers", (boolean)false);
        }
    }

    public void interestChanged(List<IInteractionElement> nodes) {
    }

    public void landmarkAdded(final IInteractionElement node) {
        if (node == null || node.getContentType() == null) {
            return;
        }
        if (node.getContentType().equals("ruby")) {
            IRubyElement element = RubyCore.create((String)node.getHandleIdentifier());
            if (!element.exists()) {
                return;
            }
            if (element instanceof IMember) {
                try {
                    final ISourceRange range = ((IMember)element).getNameRange();
                    final IResource resource = element.getUnderlyingResource();
                    if (resource instanceof IFile) {
                        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                IMarker marker = resource.createMarker(LandmarkMarkerManager.ID_MARKER_LANDMARK);
                                if (marker != null && range != null) {
                                    marker.setAttribute("charStart", range.getOffset());
                                    marker.setAttribute("charEnd", range.getOffset() + range.getLength());
                                    marker.setAttribute("message", (Object)"Mylyn Landmark");
                                    marker.setAttribute("severity", 0);
                                    LandmarkMarkerManager.this.markerMap.put(node, marker.getId());
                                }
                            }
                        };
                        resource.getWorkspace().run(runnable, null);
                    }
                }
                catch (RubyModelException e) {
                    StatusHandler.fail((Throwable)e, (String)"couldn't update marker", (boolean)false);
                }
                catch (CoreException e) {
                    StatusHandler.fail((Throwable)e, (String)"couldn't update marker", (boolean)false);
                }
            }
        }
    }

    public void landmarkRemoved(final IInteractionElement node) {
        if (node == null) {
            return;
        }
        if (node.getContentType().equals("ruby")) {
            IRubyElement element = RubyCore.create((String)node.getHandleIdentifier());
            if (!element.exists()) {
                return;
            }
            if (element.getAncestor(4) != null && element instanceof ISourceReference) {
                try {
                    final IResource resource = element.getUnderlyingResource();
                    IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            if (resource != null) {
                                try {
                                    long id;
                                    IMarker marker;
                                    if (LandmarkMarkerManager.this.markerMap.containsKey(node) && (marker = resource.getMarker(id = ((Long)LandmarkMarkerManager.this.markerMap.get(node)).longValue())) != null) {
                                        marker.delete();
                                    }
                                }
                                catch (NullPointerException e) {
                                    StatusHandler.log((Throwable)e, (String)"could not update markers");
                                }
                            }
                        }
                    };
                    resource.getWorkspace().run(runnable, null);
                }
                catch (RubyModelException rubyModelException) {
                }
                catch (CoreException e) {
                    StatusHandler.fail((Throwable)e, (String)"couldn't update landmark marker", (boolean)false);
                }
            }
        }
    }

    public void relationsChanged(IInteractionElement node) {
    }

    public void elementDeleted(IInteractionElement node) {
    }
}

