/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.mylyn.internal.ruby.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.core.IInteractionRelation;
import org.eclipse.mylyn.internal.context.ui.ContextUiImages;
import org.eclipse.mylyn.internal.context.ui.views.DelegatingContextLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.TreeHierarchyLayoutProblemsDecorator;

public class RubyContextLabelProvider
extends AppearanceAwareLabelProvider {
    private static final String LABEL_ELEMENT_MISSING = "<missing element>";

    public RubyContextLabelProvider() {
        super(0x212000000002L, 3);
    }

    public String getText(Object object) {
        if (object instanceof IInteractionElement) {
            IInteractionElement node = (IInteractionElement)object;
            if ("ruby".equals(node.getContentType())) {
                IRubyElement element = RubyCore.create((String)node.getHandleIdentifier());
                if (element == null) {
                    return LABEL_ELEMENT_MISSING;
                }
                return this.getTextForElement(element);
            }
        } else {
            if (object instanceof IInteractionRelation) {
                return this.getNameForRelationship(((IInteractionRelation)object).getRelationshipHandle());
            }
            if (object instanceof IRubyElement) {
                return this.getTextForElement((IRubyElement)object);
            }
        }
        return super.getText(object);
    }

    private String getTextForElement(IRubyElement element) {
        String parentName;
        if (DelegatingContextLabelProvider.isQualifyNamesMode() && element instanceof IMember && !(element instanceof IType) && (parentName = ((IMember)element).getParent().getElementName()) != null && parentName != "") {
            return String.valueOf(parentName) + '.' + super.getText((Object)element);
        }
        if (element.exists()) {
            return super.getText((Object)element);
        }
        return LABEL_ELEMENT_MISSING;
    }

    public Image getImage(Object object) {
        if (object instanceof IInteractionElement) {
            IInteractionElement node = (IInteractionElement)object;
            if (node.getContentType().equals("ruby")) {
                return super.getImage((Object)RubyCore.create((String)node.getHandleIdentifier()));
            }
        } else if (object instanceof IInteractionRelation) {
            ImageDescriptor descriptor = this.getIconForRelationship(((IInteractionRelation)object).getRelationshipHandle());
            if (descriptor != null) {
                return ContextUiImages.getImage((ImageDescriptor)descriptor);
            }
            return null;
        }
        return super.getImage(object);
    }

    private ImageDescriptor getIconForRelationship(String relationshipHandle) {
        if (relationshipHandle.equals("org.eclipse.mylyn.ruby.relation")) {
            return ContextUiImages.EDGE_REFERENCE;
        }
        if (relationshipHandle.equals("org.eclipse.mylyn.ruby.relation.references")) {
            return ContextUiImages.EDGE_REFERENCE;
        }
        if (relationshipHandle.equals("org.eclipse.mylyn.ruby.relation.writeaccess")) {
            return ContextUiImages.EDGE_ACCESS_WRITE;
        }
        if (relationshipHandle.equals("org.eclipse.mylyn.ruby.relation.readaccess")) {
            return ContextUiImages.EDGE_ACCESS_READ;
        }
        return null;
    }

    private String getNameForRelationship(String relationshipHandle) {
        if (relationshipHandle.equals("org.eclipse.mylyn.ruby.relation")) {
            return "Ruby relationships";
        }
        if (relationshipHandle.equals("org.eclipse.mylyn.ruby.relation.references")) {
            return "referenced by";
        }
        if (relationshipHandle.equals("org.eclipse.mylyn.ruby.relation.writeaccess")) {
            return "written by";
        }
        if (relationshipHandle.equals("org.eclipse.mylyn.ruby.relation.readaccess")) {
            return "read by";
        }
        if (relationshipHandle.equals("org.eclipse.mylyn.core.model.edges.containment")) {
            return "Containment";
        }
        return null;
    }

    public static AppearanceAwareLabelProvider createRubyUiLabelProvider() {
        AppearanceAwareLabelProvider javaUiLabelProvider = new AppearanceAwareLabelProvider(0x212000000002L, 3);
        javaUiLabelProvider.addLabelDecorator((ILabelDecorator)new TreeHierarchyLayoutProblemsDecorator());
        return javaUiLabelProvider;
    }
}

