/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.mylyn.internal.ruby.ui;

import com.aptana.rdt.mylyn.internal.ruby.ui.RubyStructureBridge;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.internal.debug.core.model.RubyDebugTarget;
import org.rubypeople.rdt.internal.debug.core.model.RubyStackFrame;
import org.rubypeople.rdt.internal.debug.core.model.RubyThread;
import org.rubypeople.rdt.internal.debug.core.model.RubyValue;
import org.rubypeople.rdt.internal.debug.core.model.RubyVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyDebugStructureBridge
extends AbstractContextStructureBridge {
    public static final String CONTENT_TYPE = "java/debug";
    private RubyStructureBridge javaStructureBridge = new RubyStructureBridge();
    private Map<RubyStackFrame, IType> stackFrameMap = new WeakHashMap<RubyStackFrame, IType>();

    public boolean acceptsObject(Object object) {
        return object instanceof ILaunch || object instanceof RubyStackFrame || object instanceof RuntimeProcess || object instanceof RubyVariable || object instanceof RubyValue || object instanceof RubyThread || object instanceof RubyDebugTarget;
    }

    public boolean canBeLandmark(String handle) {
        return false;
    }

    public boolean canFilter(Object element) {
        if (element instanceof RubyStackFrame) {
            RubyStackFrame stackFrame = (RubyStackFrame)element;
            try {
                IStackFrame[] frames = stackFrame.getThread().getStackFrames();
                int indexOfInterestingFrame = 0;
                int indexOfCurrentFrame = 0;
                int i = 0;
                while (i < frames.length) {
                    IInteractionElement correspondingElement;
                    IStackFrame frame = frames[i];
                    if (stackFrame.getName().equals(frame.getName())) {
                        indexOfCurrentFrame = i;
                    }
                    if ((correspondingElement = ContextCorePlugin.getContextManager().getElement(this.getHandleIdentifier(frame))) != null && correspondingElement.getInterest().isInteresting()) {
                        indexOfInterestingFrame = i;
                    }
                    ++i;
                }
                return indexOfCurrentFrame > indexOfInterestingFrame;
            }
            catch (DebugException debugException) {
                return false;
            }
        }
        return element instanceof RubyStackFrame;
    }

    public List<String> getChildHandles(String handle) {
        return null;
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public String getContentType(String elementHandle) {
        return this.getContentType();
    }

    public String getHandleForOffsetInObject(Object resource, int offset) {
        return null;
    }

    public String getHandleIdentifier(Object object) {
        return null;
    }

    public String getLabel(Object object) {
        return "" + object;
    }

    public Object getObjectForHandle(String handle) {
        return this.javaStructureBridge.getObjectForHandle(handle);
    }

    public String getParentHandle(String handle) {
        return null;
    }

    public boolean isDocument(String handle) {
        return false;
    }
}

