/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.mylyn.internal.ruby.ui;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.actions.SelectionConverter;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyOutlinePage;
import org.rubypeople.rdt.ui.RubyUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyUiBridge
extends AbstractContextUiBridge {
    private Field rubyOutlineField = null;

    public RubyUiBridge() {
        try {
            this.rubyOutlineField = RubyOutlinePage.class.getDeclaredField("fOutlineViewer");
            this.rubyOutlineField.setAccessible(true);
        }
        catch (Exception e) {
            StatusHandler.fail((Throwable)e, (String)"could not get install Mylyn on Outline viewer", (boolean)true);
        }
    }

    public void open(IInteractionElement node) {
        IRubyElement rubyElement = RubyCore.create((String)node.getHandleIdentifier());
        if (rubyElement == null || !rubyElement.exists()) {
            return;
        }
        try {
            IEditorPart part = RubyUI.openInEditor((IRubyElement)rubyElement);
            RubyUI.revealInEditor((IEditorPart)part, (IRubyElement)rubyElement);
        }
        catch (Throwable t) {
            StatusHandler.fail((Throwable)t, (String)("Could not open editor for: " + node), (boolean)true);
        }
    }

    public void close(IInteractionElement node) {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null) {
                IEditorReference[] references = page.getEditorReferences();
                int i = 0;
                while (i < references.length) {
                    RubyEditor editor;
                    Object adapter;
                    IEditorPart part = references[i].getEditor(false);
                    if (part != null && part instanceof RubyEditor && (adapter = (editor = (RubyEditor)part).getEditorInput().getAdapter(IRubyElement.class)) instanceof IRubyElement && node.getHandleIdentifier().equals(((IRubyElement)adapter).getHandleIdentifier())) {
                        editor.close(true);
                    }
                    ++i;
                }
            }
        }
        catch (Throwable t) {
            StatusHandler.fail((Throwable)t, (String)"Could not auto close editor.", (boolean)false);
        }
    }

    public boolean acceptsEditor(IEditorPart editorPart) {
        return editorPart instanceof RubyEditor;
    }

    public IInteractionElement getElement(IEditorInput input) {
        Object adapter = input.getAdapter(IRubyElement.class);
        if (adapter instanceof IRubyElement) {
            IRubyElement rubyElement = (IRubyElement)adapter;
            String handle = ContextCorePlugin.getDefault().getStructureBridge((Object)rubyElement).getHandleIdentifier((Object)rubyElement);
            return ContextCorePlugin.getContextManager().getElement(handle);
        }
        return null;
    }

    public List<TreeViewer> getContentOutlineViewers(IEditorPart editorPart) {
        RubyOutlinePage page;
        if (editorPart == null || this.rubyOutlineField == null) {
            return null;
        }
        ArrayList<TreeViewer> viewers = new ArrayList<TreeViewer>();
        Object out = editorPart.getAdapter(IContentOutlinePage.class);
        if (out instanceof RubyOutlinePage && (page = (RubyOutlinePage)out).getControl() != null) {
            try {
                viewers.add((TreeViewer)this.rubyOutlineField.get(page));
            }
            catch (Exception e) {
                StatusHandler.log((Throwable)e, (String)"could not get outline viewer");
            }
        }
        return viewers;
    }

    public Object getObjectForTextSelection(TextSelection selection, IEditorPart editor) {
        if (editor instanceof RubyEditor) {
            TextSelection textSelection = selection;
            try {
                if (selection != null) {
                    return SelectionConverter.resolveEnclosingElement((RubyEditor)((RubyEditor)editor), (ITextSelection)textSelection);
                }
                Object element = ((RubyEditor)editor).getEditorInput().getAdapter(IRubyElement.class);
                if (element instanceof IRubyElement) {
                    return element;
                }
            }
            catch (RubyModelException rubyModelException) {}
        }
        return null;
    }

    public String getContentType() {
        return "ruby";
    }
}

