/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.mylyn.internal.ruby.ui;

import com.aptana.rdt.mylyn.internal.ruby.ui.ActiveFoldingEditorTracker;
import com.aptana.rdt.mylyn.internal.ruby.ui.InterestInducingProblemListener;
import com.aptana.rdt.mylyn.internal.ruby.ui.InterestUpdateDeltaListener;
import com.aptana.rdt.mylyn.internal.ruby.ui.LandmarkMarkerManager;
import com.aptana.rdt.mylyn.internal.ruby.ui.RubyEditingMonitor;
import com.aptana.rdt.mylyn.internal.ruby.ui.editor.ActiveFoldingListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionContextListener;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.monitor.ui.MonitorUiPlugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.rubypeople.rdt.core.IElementChangedListener;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;

public class RubyUiBridgePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.aptana.rdt.mylyn";
    private static RubyUiBridgePlugin plugin;
    private RubyEditingMonitor rubyEditingMonitor;
    private ActiveFoldingEditorTracker editorTracker;
    private LandmarkMarkerManager landmarkMarkerManager = new LandmarkMarkerManager();
    private InterestInducingProblemListener problemListener = new InterestInducingProblemListener();
    private InterestUpdateDeltaListener rubyElementChangeListener = new InterestUpdateDeltaListener();

    public RubyUiBridgePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    ContextCorePlugin.getContextManager().addListener((IInteractionContextListener)RubyUiBridgePlugin.this.landmarkMarkerManager);
                    if (RubyUiBridgePlugin.this.getPreferenceStore().getBoolean("com.aptana.rdt.mylyn.ruby.ui.interest.prediction.errors")) {
                        RubyUiBridgePlugin.this.problemListener.enable();
                    }
                    RubyUiBridgePlugin.this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)RubyUiBridgePlugin.this.problemListener);
                    RubyUiBridgePlugin.this.rubyEditingMonitor = new RubyEditingMonitor();
                    MonitorUiPlugin.getDefault().getSelectionMonitors().add(RubyUiBridgePlugin.this.rubyEditingMonitor);
                    RubyUiBridgePlugin.this.installEditorTracker(workbench);
                    RubyCore.addElementChangedListener((IElementChangedListener)RubyUiBridgePlugin.this.rubyElementChangeListener);
                }
                catch (Throwable t) {
                    StatusHandler.fail((Throwable)t, (String)"Mylyn Ruby plug-in initialization failed", (boolean)true);
                }
            }
        });
    }

    private void installEditorTracker(IWorkbench workbench) {
        this.editorTracker = new ActiveFoldingEditorTracker();
        this.editorTracker.install(workbench);
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = 0;
        int n2 = iWorkbenchWindowArray.length;
        while (n < n2) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n];
            IWorkbenchPage page = w.getActivePage();
            if (page != null) {
                IEditorReference[] references = page.getEditorReferences();
                int i = 0;
                while (i < references.length) {
                    IEditorPart part = references[i].getEditor(false);
                    if (part != null && part instanceof RubyEditor) {
                        RubyEditor editor = (RubyEditor)part;
                        this.editorTracker.registerEditor(editor);
                        ActiveFoldingListener.resetProjection(editor);
                    }
                    ++i;
                }
            }
            ++n;
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            super.stop(context);
            plugin = null;
            ContextCorePlugin.getContextManager().removeListener((IInteractionContextListener)this.landmarkMarkerManager);
            MonitorUiPlugin.getDefault().getSelectionMonitors().remove((Object)this.rubyEditingMonitor);
            RubyCore.removeElementChangedListener((IElementChangedListener)this.rubyElementChangeListener);
        }
        catch (Exception e) {
            StatusHandler.fail((Throwable)e, (String)"Mylyn Ruby stop terminated abnormally", (boolean)false);
        }
    }

    public static RubyUiBridgePlugin getDefault() {
        return plugin;
    }
}

