/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.mylyn.internal.ruby.ui.editor;

import com.aptana.rdt.mylyn.internal.ruby.ui.RubyStructureBridge;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextListener;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.ui.IEditorInput;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.ui.RubyUI;
import org.rubypeople.rdt.ui.text.folding.IRubyFoldingStructureProvider;
import org.rubypeople.rdt.ui.text.folding.IRubyFoldingStructureProviderExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveFoldingListener
implements IInteractionContextListener {
    private final RubyEditor editor;
    private IRubyFoldingStructureProviderExtension updater;
    private static RubyStructureBridge bridge = (RubyStructureBridge)ContextCorePlugin.getDefault().getStructureBridge("ruby");
    private boolean enabled = false;
    private Preferences.IPropertyChangeListener PREFERENCE_LISTENER = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.mylyn.context.ui.editor.folding.enabled")) {
                if (event.getNewValue().equals(Boolean.TRUE.toString())) {
                    ActiveFoldingListener.this.enabled = true;
                } else {
                    ActiveFoldingListener.this.enabled = false;
                }
                ActiveFoldingListener.this.updateFolding();
            }
        }
    };

    public ActiveFoldingListener(RubyEditor editor) {
        this.editor = editor;
        if (ContextUiPlugin.getDefault() == null) {
            StatusHandler.fail(null, (String)"Could not update folding, Mylyn is not correctly installed", (boolean)false);
        } else {
            ContextCorePlugin.getContextManager().addListener((IInteractionContextListener)this);
            ContextUiPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(this.PREFERENCE_LISTENER);
            this.enabled = ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled");
            try {
                Object adapter = editor.getAdapter(IRubyFoldingStructureProvider.class);
                if (adapter instanceof IRubyFoldingStructureProviderExtension) {
                    this.updater = (IRubyFoldingStructureProviderExtension)adapter;
                } else {
                    StatusHandler.log((String)("Could not install active folding on provider: " + adapter + ", must extend " + IRubyFoldingStructureProviderExtension.class.getName()), (Object)this);
                }
            }
            catch (Exception e) {
                StatusHandler.fail((Throwable)e, (String)"could not install auto folding, reflection denied", (boolean)false);
            }
            this.updateFolding();
        }
    }

    public void dispose() {
        ContextCorePlugin.getContextManager().removeListener((IInteractionContextListener)this);
        ContextUiPlugin.getDefault().getPluginPreferences().removePropertyChangeListener(this.PREFERENCE_LISTENER);
    }

    public static void resetProjection(RubyEditor javaEditor) {
    }

    public void updateFolding() {
        if (!this.enabled || !ContextCorePlugin.getContextManager().isContextActive()) {
            this.editor.resetProjection();
        } else {
            if (this.editor.getEditorInput() == null) {
                return;
            }
            try {
                ArrayList<IRubyElement> toExpand = new ArrayList<IRubyElement>();
                ArrayList<IRubyElement> toCollapse = new ArrayList<IRubyElement>();
                IRubyElement element = RubyUI.getEditorInputRubyElement((IEditorInput)this.editor.getEditorInput());
                if (element instanceof IRubyScript) {
                    IRubyScript compilationUnit = (IRubyScript)element;
                    List<IRubyElement> allChildren = ActiveFoldingListener.getAllChildren((IParent)compilationUnit);
                    for (IRubyElement child : allChildren) {
                        IInteractionElement interactionElement = ContextCorePlugin.getContextManager().getElement(bridge.getHandleIdentifier(child));
                        if (interactionElement != null && interactionElement.getInterest().isInteresting()) {
                            toExpand.add(child);
                            continue;
                        }
                        toCollapse.add(child);
                    }
                }
                if (this.updater != null) {
                    this.updater.collapseMembers();
                    this.updater.expandElements(toExpand.toArray(new IRubyElement[toExpand.size()]));
                }
            }
            catch (Exception e) {
                StatusHandler.fail((Throwable)e, (String)"couldn't update folding", (boolean)false);
            }
        }
    }

    private static List<IRubyElement> getAllChildren(IParent parentElement) {
        ArrayList<IRubyElement> allChildren = new ArrayList<IRubyElement>();
        try {
            IRubyElement[] iRubyElementArray = parentElement.getChildren();
            int n = 0;
            int n2 = iRubyElementArray.length;
            while (n < n2) {
                IRubyElement child = iRubyElementArray[n];
                allChildren.add(child);
                if (child instanceof IParent) {
                    allChildren.addAll(ActiveFoldingListener.getAllChildren((IParent)child));
                }
                ++n;
            }
        }
        catch (RubyModelException rubyModelException) {}
        return allChildren;
    }

    public void interestChanged(List<IInteractionElement> elements) {
        for (IInteractionElement element : elements) {
            if (this.updater == null || !this.enabled) {
                return;
            }
            Object object = bridge.getObjectForHandle(element.getHandleIdentifier());
            if (!(object instanceof IMember)) continue;
            IMember member = (IMember)object;
            if (element.getInterest().isInteresting()) {
                this.updater.expandElements(new IRubyElement[]{member});
                try {
                    IRubyElement[] childsChildren;
                    IRubyElement[] children = member.getChildren();
                    if (children.length != 1) continue;
                    this.updater.expandElements(new IRubyElement[]{children[0]});
                    if (!(children[0] instanceof IParent) || (childsChildren = ((IParent)children[0]).getChildren()).length != 1) continue;
                    this.updater.expandElements(new IRubyElement[]{childsChildren[0]});
                }
                catch (RubyModelException rubyModelException) {}
                continue;
            }
            this.updater.collapseElements(new IRubyElement[]{member});
        }
    }

    public void contextActivated(IInteractionContext context) {
        if (ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled")) {
            this.updateFolding();
        }
    }

    public void contextDeactivated(IInteractionContext context) {
        if (ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled")) {
            this.updateFolding();
        }
    }

    public void contextCleared(IInteractionContext context) {
        if (ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled")) {
            this.updateFolding();
        }
    }

    public void landmarkAdded(IInteractionElement element) {
    }

    public void landmarkRemoved(IInteractionElement element) {
    }

    public void relationsChanged(IInteractionElement node) {
    }

    public void elementDeleted(IInteractionElement node) {
    }
}

