/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.mylyn.internal.ruby.ui.search;

import com.aptana.rdt.mylyn.internal.ruby.ui.search.RubyActiveSearchResultUpdater;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.AbstractRelationProvider;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IDegreeOfSeparation;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.DegreeOfSeparation;
import org.eclipse.mylyn.internal.context.core.IActiveSearchListener;
import org.eclipse.mylyn.internal.context.core.IActiveSearchOperation;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.resources.ResourcesUiBridgePlugin;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.rubypeople.rdt.core.IImportDeclaration;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.ui.search.RubySearchQuery;
import org.rubypeople.rdt.internal.ui.search.RubySearchResult;
import org.rubypeople.rdt.ui.search.ElementQuerySpecification;
import org.rubypeople.rdt.ui.search.QuerySpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRubyRelationProvider
extends AbstractRelationProvider {
    public static final String ID_GENERIC = "org.eclipse.mylyn.ruby.relation";
    public static final String NAME = "Ruby relationships";
    private static final int DEFAULT_DEGREE = 2;
    private static final List<Job> runningJobs = new ArrayList<Job>();

    public String getGenericId() {
        return ID_GENERIC;
    }

    protected AbstractRubyRelationProvider(String structureKind, String id) {
        super(structureKind, id);
    }

    public List<IDegreeOfSeparation> getDegreesOfSeparation() {
        ArrayList<IDegreeOfSeparation> separations = new ArrayList<IDegreeOfSeparation>();
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("disabled", 0));
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("landmark resources", 1));
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("interesting resources", 2));
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("interesting projects", 3));
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("project dependencies", 4));
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("entire workspace (slow)", 5));
        return separations;
    }

    protected void findRelated(IInteractionElement node, int degreeOfSeparation) {
        if (node == null) {
            return;
        }
        if (node.getContentType() == null) {
            StatusHandler.log((String)("null content type for: " + node), (Object)((Object)this));
            return;
        }
        if (!node.getContentType().equals("ruby")) {
            return;
        }
        IRubyElement rubyElement = RubyCore.create((String)node.getHandleIdentifier());
        if (!this.acceptElement(rubyElement) || !rubyElement.exists()) {
            return;
        }
        IRubySearchScope scope = this.createRubySearchScope(rubyElement, degreeOfSeparation);
        if (scope != null) {
            this.runJob(node, degreeOfSeparation, this.getId());
        }
    }

    private IRubySearchScope createRubySearchScope(IRubyElement element, int degreeOfSeparation) {
        AbstractContextStructureBridge bridge;
        List landmarks = ContextCorePlugin.getContextManager().getActiveLandmarks();
        List interestingElements = ContextCorePlugin.getContextManager().getActiveContext().getInteresting();
        HashSet<Object> searchElements = new HashSet<Object>();
        int includeMask = 1;
        if (degreeOfSeparation == 1) {
            for (IInteractionElement landmark : landmarks) {
                IRubyElement landmarkElement;
                Object o;
                if (!this.includeNodeInScope(landmark, bridge = ContextCorePlugin.getDefault().getStructureBridge(landmark.getContentType())) || !((o = bridge.getObjectForHandle(landmark.getHandleIdentifier())) instanceof IRubyElement) || !(landmarkElement = (IRubyElement)o).exists()) continue;
                if (landmarkElement instanceof IMember && !landmark.getInterest().isPropagated()) {
                    searchElements.add(((IMember)landmarkElement).getRubyScript());
                    continue;
                }
                if (!(landmarkElement instanceof IRubyScript)) continue;
                searchElements.add(landmarkElement);
            }
        } else if (degreeOfSeparation == 2) {
            for (IInteractionElement interesting : interestingElements) {
                IRubyElement interestingElement;
                Object object;
                if (!this.includeNodeInScope(interesting, bridge = ContextCorePlugin.getDefault().getStructureBridge(interesting.getContentType())) || !((object = bridge.getObjectForHandle(interesting.getHandleIdentifier())) instanceof IRubyElement) || !(interestingElement = (IRubyElement)object).exists()) continue;
                if (interestingElement instanceof IMember && !interesting.getInterest().isPropagated()) {
                    searchElements.add(((IMember)interestingElement).getRubyScript());
                    continue;
                }
                if (!(interestingElement instanceof IRubyScript)) continue;
                searchElements.add(interestingElement);
            }
        } else if (degreeOfSeparation == 3 || degreeOfSeparation == 4) {
            for (IInteractionElement interesting : interestingElements) {
                IRubyProject rubyProject;
                IProject project;
                IResource resource;
                if (!this.includeNodeInScope(interesting, bridge = ContextCorePlugin.getDefault().getStructureBridge(interesting.getContentType())) || (resource = ResourcesUiBridgePlugin.getDefault().getResourceForElement(interesting, true)) == null || (project = resource.getProject()) == null || !RubyProject.hasRubyNature((IProject)project) || !project.exists() || (rubyProject = RubyCore.create((IProject)project)) == null || !rubyProject.exists()) continue;
                searchElements.add(rubyProject);
            }
            if (degreeOfSeparation == 4) {
                includeMask = 7;
            }
        } else if (degreeOfSeparation == 5) {
            return SearchEngine.createWorkspaceScope();
        }
        if (searchElements.size() == 0) {
            return null;
        }
        IRubyElement[] elements = new IRubyElement[searchElements.size()];
        int j = 0;
        Iterator iterator = searchElements.iterator();
        while (iterator.hasNext()) {
            IRubyElement searchElement;
            elements[j] = searchElement = (IRubyElement)iterator.next();
            ++j;
        }
        return SearchEngine.createRubySearchScope((IRubyElement[])elements, (int)includeMask);
    }

    private boolean includeNodeInScope(IInteractionElement interesting, AbstractContextStructureBridge bridge) {
        if (interesting == null || bridge == null) {
            return false;
        }
        if (interesting.getContentType() == null) {
            StatusHandler.log((String)("null content type for: " + interesting.getHandleIdentifier()), (Object)((Object)this));
            return false;
        }
        return interesting.getContentType().equals("ruby") || bridge.isDocument(interesting.getHandleIdentifier());
    }

    protected boolean acceptResultElement(IRubyElement element) {
        return !(element instanceof IImportDeclaration);
    }

    protected boolean acceptElement(IRubyElement rubyElement) {
        return rubyElement != null && (rubyElement instanceof IMember || rubyElement instanceof IType);
    }

    private void runJob(final IInteractionElement node, final int degreeOfSeparation, String kind) {
        int limitTo = 0;
        if (kind.equals("org.eclipse.mylyn.ruby.relation.references")) {
            limitTo = 1;
        } else if (kind.equals("org.eclipse.mylyn.ruby.relation.readaccess")) {
            limitTo = 1;
        } else if (kind.equals("org.eclipse.mylyn.ruby.relation.writeaccess")) {
            limitTo = 1;
        }
        RubySearchOperation query = (RubySearchOperation)this.getSearchOperation(node, limitTo, degreeOfSeparation);
        if (query == null) {
            return;
        }
        RubySearchJob job = new RubySearchJob(query.getLabel(), query);
        query.addListener(new IActiveSearchListener(){
            private boolean gathered = false;

            public boolean resultsGathered() {
                return this.gathered;
            }

            public void searchCompleted(List l) {
                if (l == null) {
                    return;
                }
                ArrayList<IRubyElement> relatedHandles = new ArrayList<IRubyElement>();
                Object[] elements = l.toArray();
                int i = 0;
                while (i < elements.length) {
                    if (elements[i] instanceof IRubyElement) {
                        relatedHandles.add((IRubyElement)elements[i]);
                    }
                    ++i;
                }
                for (IRubyElement element : relatedHandles) {
                    if (!AbstractRubyRelationProvider.this.acceptResultElement(element)) continue;
                    AbstractRubyRelationProvider.this.incrementInterest(node, "ruby", element.getHandleIdentifier(), degreeOfSeparation);
                }
                this.gathered = true;
                AbstractRubyRelationProvider.this.searchCompleted(node);
            }
        });
        InternalSearchUI.getInstance();
        runningJobs.add(job);
        job.setPriority(40);
        job.schedule();
    }

    public IActiveSearchOperation getSearchOperation(IInteractionElement node, int limitTo, int degreeOfSeparation) {
        IRubyElement rubyElement = RubyCore.create((String)node.getHandleIdentifier());
        if (rubyElement == null || !rubyElement.exists()) {
            return null;
        }
        IRubySearchScope scope = this.createRubySearchScope(rubyElement, degreeOfSeparation);
        if (scope == null) {
            return null;
        }
        ElementQuerySpecification specs = new ElementQuerySpecification(rubyElement, limitTo, scope, "Mylyn degree of separation: " + degreeOfSeparation);
        return new RubySearchOperation((QuerySpecification)specs);
    }

    public void stopAllRunningJobs() {
        for (Job j : runningJobs) {
            j.cancel();
        }
        runningJobs.clear();
    }

    protected int getDefaultDegreeOfSeparation() {
        return 2;
    }

    protected static class RubySearchJob
    extends Job {
        private RubySearchOperation op;

        public RubySearchJob(String name, RubySearchOperation op) {
            super(name);
            this.op = op;
        }

        protected IStatus run(IProgressMonitor monitor) {
            return this.op.run(monitor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RubySearchOperation
    extends RubySearchQuery
    implements IActiveSearchOperation {
        private ISearchResult result = null;
        private List<IActiveSearchListener> listeners = new ArrayList<IActiveSearchListener>();

        public ISearchResult getSearchResult() {
            if (this.result == null) {
                this.result = new RubySearchResult((RubySearchQuery)this);
            }
            new RubyActiveSearchResultUpdater((RubySearchResult)this.result);
            return this.result;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                IStatus runStatus = super.run(monitor);
                ISearchResult result = this.getSearchResult();
                if (result instanceof RubySearchResult) {
                    Object[] objs = ((RubySearchResult)result).getElements();
                    if (objs == null) {
                        this.notifySearchCompleted(null);
                    } else {
                        ArrayList<Object> l = new ArrayList<Object>();
                        int i = 0;
                        while (i < objs.length) {
                            l.add(objs[i]);
                            ++i;
                        }
                        this.notifySearchCompleted(l);
                    }
                }
                return runStatus;
            }
            catch (ConcurrentModificationException cme) {
                StatusHandler.log((Throwable)cme, (String)"ruby search failed");
            }
            catch (Throwable t) {
                StatusHandler.log((Throwable)t, (String)"ruby search failed");
            }
            Status status = new Status(2, "org.eclipse.mylyn.core", 0, "could not run Ruby search", null);
            this.notifySearchCompleted(null);
            return status;
        }

        public RubySearchOperation(QuerySpecification data) {
            super(data);
        }

        public void addListener(IActiveSearchListener l) {
            this.listeners.add(l);
        }

        public void removeListener(IActiveSearchListener l) {
            this.listeners.remove(l);
        }

        public void notifySearchCompleted(List<Object> l) {
            for (IActiveSearchListener listener : this.listeners) {
                listener.searchCompleted(l);
            }
        }
    }
}

