/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.mylyn.internal.ruby.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.rubypeople.rdt.core.IRubyElement;

class TreeParent
implements IAdaptable {
    protected IRubyElement element;
    protected TreeParent parent;
    private List<TreeParent> children;
    private String relationshipName;

    public TreeParent(IRubyElement element) {
        this.element = element;
        this.children = new ArrayList<TreeParent>();
    }

    public TreeParent(String relationshipName) {
        this.relationshipName = relationshipName;
        this.children = new ArrayList<TreeParent>();
    }

    public String getName() {
        return this.element.getElementName();
    }

    public void setParent(TreeParent parent) {
        this.parent = parent;
    }

    public TreeParent getParent() {
        return this.parent;
    }

    public Object getAdapter(Class key) {
        return this.element;
    }

    public IRubyElement getElement() {
        return this.element;
    }

    public String toString() {
        if (this.getElement() == null) {
            return this.relationshipName;
        }
        return this.getName();
    }

    public void addChild(TreeParent child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void removeAllChildren() {
        for (TreeParent node : this.children) {
            if (node == null) continue;
            node.setParent(null);
        }
        this.children.clear();
    }

    public void removeChild(TreeParent child) {
        this.children.remove(child);
        child.setParent(null);
    }

    public TreeParent[] getChildren() {
        return this.children.toArray(new TreeParent[this.children.size()]);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }
}

