/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommandLine;
import org.tmatesoft.svn.cli.SVNConsoleAuthenticationProvider;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNDebugLog;

public abstract class SVNCommand {
    private SVNCommandLine myCommandLine;
    private String myUserName;
    private String myPassword;
    private static Map ourCommands = new HashMap();
    private static Set ourPegCommands;
    private static HashSet ourForceLogCommands;
    private boolean myIsStoreCreds;
    private SVNClientManager myClientManager;

    protected SVNCommandLine getCommandLine() {
        return this.myCommandLine;
    }

    public void setCommandLine(SVNCommandLine commandLine) {
        this.myCommandLine = commandLine;
        this.myUserName = (String)commandLine.getArgumentValue(SVNArgument.USERNAME);
        this.myPassword = (String)commandLine.getArgumentValue(SVNArgument.PASSWORD);
        this.myIsStoreCreds = !commandLine.hasArgument(SVNArgument.NO_AUTH_CACHE);
    }

    public abstract void run(PrintStream var1, PrintStream var2) throws SVNException;

    public abstract void run(InputStream var1, PrintStream var2, PrintStream var3) throws SVNException;

    private ISVNOptions getOptions() {
        String dir = (String)this.getCommandLine().getArgumentValue(SVNArgument.CONFIG_DIR);
        File dirFile = dir == null ? null : new File(dir);
        ISVNOptions options = SVNWCUtil.createDefaultOptions((File)dirFile, (boolean)true);
        options.setAuthStorageEnabled(this.myIsStoreCreds);
        return options;
    }

    protected SVNClientManager getClientManager() {
        if (this.myClientManager == null) {
            String dir = (String)this.getCommandLine().getArgumentValue(SVNArgument.CONFIG_DIR);
            File dirFile = dir == null ? null : new File(dir);
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((File)dirFile, (String)this.myUserName, (String)this.myPassword, (boolean)this.getOptions().isAuthStorageEnabled());
            if (!this.myCommandLine.hasArgument(SVNArgument.NON_INTERACTIVE)) {
                authManager.setAuthenticationProvider((ISVNAuthenticationProvider)new SVNConsoleAuthenticationProvider());
            }
            this.myClientManager = SVNClientManager.newInstance((ISVNOptions)this.getOptions(), (ISVNAuthenticationManager)authManager);
        }
        return this.myClientManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getCommitMessage() throws SVNException {
        String fileName = (String)this.getCommandLine().getArgumentValue(SVNArgument.FILE);
        if (fileName == null) return (String)this.getCommandLine().getArgumentValue(SVNArgument.MESSAGE);
        FileInputStream is = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            try {
                is = new FileInputStream(fileName);
                while (true) {
                    int r;
                    if ((r = is.read()) < 0) {
                        Object var7_8 = null;
                        break;
                    }
                    if (r == 0) {
                        SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_BAD_LOG_MESSAGE, (String)"error: commit message contains a zero byte");
                        throw new SVNException(err);
                    }
                    bos.write(r);
                }
            }
            catch (IOException e) {
                SVNErrorMessage msg = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_BAD_LOG_MESSAGE, (String)e.getLocalizedMessage());
                throw new SVNException(msg, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (is != null) {
                    is.close();
                }
                bos.close();
                throw throwable;
            }
            catch (IOException e) {
                SVNErrorMessage msg = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_BAD_LOG_MESSAGE, (String)e.getLocalizedMessage());
                throw new SVNException(msg, (Throwable)e);
            }
        }
        try {}
        catch (IOException e) {
            SVNErrorMessage msg = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_BAD_LOG_MESSAGE, (String)e.getLocalizedMessage());
            throw new SVNException(msg, (Throwable)e);
        }
        if (is != null) {
            is.close();
        }
        bos.close();
        return new String(bos.toByteArray());
    }

    public static String formatString(String str, int chars, boolean left) {
        if (str.length() > chars) {
            return str.substring(0, chars);
        }
        StringBuffer formatted = new StringBuffer();
        if (left) {
            formatted.append(str);
        }
        for (int i = 0; i < chars - str.length(); ++i) {
            formatted.append(' ');
        }
        if (!left) {
            formatted.append(str);
        }
        return formatted.toString();
    }

    public static SVNCommand getCommand(String name) {
        return SVNCommand.getCommand(name, ourCommands);
    }

    public static SVNCommand getCommand(String name, Map commands) {
        if (name == null) {
            return null;
        }
        String className = null;
        Iterator keys = commands.keySet().iterator();
        while (keys.hasNext()) {
            String[] names = (String[])keys.next();
            for (int i = 0; i < names.length; ++i) {
                if (!name.equals(names[i])) continue;
                className = (String)commands.get(names);
                break;
            }
            if (className == null) continue;
            break;
        }
        if (className == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            if (clazz != null) {
                return (SVNCommand)clazz.newInstance();
            }
        }
        catch (Throwable th) {
            SVNDebugLog.getDefaultLog().info(th);
        }
        return null;
    }

    public static boolean hasPegRevision(String commandName) {
        String fullName = SVNCommand.getFullCommandName(commandName);
        return fullName != null && ourPegCommands.contains(fullName);
    }

    public static boolean isForceLogCommand(String commandName) {
        String fullName = SVNCommand.getFullCommandName(commandName);
        return fullName != null && ourForceLogCommands.contains(fullName);
    }

    private static String getFullCommandName(String commandName) {
        if (commandName == null) {
            return null;
        }
        String fullName = null;
        Iterator keys = ourCommands.keySet().iterator();
        while (keys.hasNext()) {
            String[] names = (String[])keys.next();
            for (int i = 0; i < names.length; ++i) {
                if (!commandName.equalsIgnoreCase(names[i])) continue;
                fullName = names[0];
                break;
            }
            if (fullName == null) continue;
            break;
        }
        return fullName;
    }

    protected static SVNRevision parseRevision(SVNCommandLine commandLine) {
        if (commandLine.hasArgument(SVNArgument.REVISION)) {
            String revStr = (String)commandLine.getArgumentValue(SVNArgument.REVISION);
            return SVNRevision.parse((String)revStr);
        }
        return SVNRevision.UNDEFINED;
    }

    public static void println(PrintStream out, String line) {
        out.println(line);
        SVNDebugLog.getDefaultLog().info(line);
    }

    public static void print(PrintStream out, String line) {
        out.print(line);
    }

    public static void println(PrintStream out) {
        out.println();
    }

    protected static boolean matchTabsInPath(String path, PrintStream out) {
        if (path != null && path.indexOf(9) >= 0) {
            out.println("svn: Invalid control character '0x09' in path '" + path + "'");
            return true;
        }
        return false;
    }

    protected static boolean matchTabsInURL(String url, PrintStream out) {
        String path = null;
        try {
            path = SVNURL.parseURIEncoded((String)url).getURIEncodedPath();
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        if (path != null && path.indexOf("%09") >= 0) {
            out.println("svn: Invalid control character '0x09' in path '" + url + "'");
            return true;
        }
        return false;
    }

    protected static int getLinesCount(String str) {
        if ("".equals(str)) {
            return 1;
        }
        int count = 0;
        StringTokenizer lines = new StringTokenizer(str, "\r\n");
        while (lines.hasMoreTokens()) {
            lines.nextToken();
            ++count;
        }
        return count;
    }

    protected SVNRevision[] getStartEndRevisions() {
        String revStr = (String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION);
        SVNRevision startRevision = SVNRevision.UNDEFINED;
        SVNRevision endRevision = SVNRevision.UNDEFINED;
        if (revStr != null && revStr.indexOf("}:{") > 0) {
            startRevision = SVNRevision.parse((String)revStr.substring(0, revStr.indexOf("}:{") + 1));
            endRevision = SVNRevision.parse((String)revStr.substring(revStr.indexOf("}:{") + 2));
        } else if (revStr != null && revStr.indexOf(58) > 0 && revStr.indexOf(123) < 0 && revStr.indexOf(125) < 0) {
            startRevision = SVNRevision.parse((String)revStr.substring(0, revStr.indexOf(58)));
            endRevision = SVNRevision.parse((String)revStr.substring(revStr.indexOf(58) + 1));
        } else if (revStr != null) {
            startRevision = SVNRevision.parse((String)revStr);
        }
        return new SVNRevision[]{startRevision, endRevision};
    }

    static {
        ourCommands.put(new String[]{"status", "st", "stat"}, "org.tmatesoft.svn.cli.command.SVNStatusCommand");
        ourCommands.put(new String[]{"import"}, "org.tmatesoft.svn.cli.command.SVNImportCommand");
        ourCommands.put(new String[]{"checkout", "co"}, "org.tmatesoft.svn.cli.command.SVNCheckoutCommand");
        ourCommands.put(new String[]{"add"}, "org.tmatesoft.svn.cli.command.SVNAddCommand");
        ourCommands.put(new String[]{"commit", "ci"}, "org.tmatesoft.svn.cli.command.SVNCommitCommand");
        ourCommands.put(new String[]{"update", "up"}, "org.tmatesoft.svn.cli.command.SVNUpdateCommand");
        ourCommands.put(new String[]{"delete", "rm", "remove", "del"}, "org.tmatesoft.svn.cli.command.SVNDeleteCommand");
        ourCommands.put(new String[]{"move", "mv", "rename", "ren"}, "org.tmatesoft.svn.cli.command.SVNMoveCommand");
        ourCommands.put(new String[]{"copy", "cp"}, "org.tmatesoft.svn.cli.command.SVNCopyCommand");
        ourCommands.put(new String[]{"revert"}, "org.tmatesoft.svn.cli.command.SVNRevertCommand");
        ourCommands.put(new String[]{"mkdir"}, "org.tmatesoft.svn.cli.command.SVNMkDirCommand");
        ourCommands.put(new String[]{"propset", "pset", "ps"}, "org.tmatesoft.svn.cli.command.SVNPropsetCommand");
        ourCommands.put(new String[]{"propdel", "pdel", "pd"}, "org.tmatesoft.svn.cli.command.SVNPropdelCommand");
        ourCommands.put(new String[]{"propget", "pget", "pg"}, "org.tmatesoft.svn.cli.command.SVNPropgetCommand");
        ourCommands.put(new String[]{"proplist", "plist", "pl"}, "org.tmatesoft.svn.cli.command.SVNProplistCommand");
        ourCommands.put(new String[]{"info"}, "org.tmatesoft.svn.cli.command.SVNInfoCommand");
        ourCommands.put(new String[]{"resolved"}, "org.tmatesoft.svn.cli.command.SVNResolvedCommand");
        ourCommands.put(new String[]{"cat"}, "org.tmatesoft.svn.cli.command.SVNCatCommand");
        ourCommands.put(new String[]{"ls", "list"}, "org.tmatesoft.svn.cli.command.SVNLsCommand");
        ourCommands.put(new String[]{"log"}, "org.tmatesoft.svn.cli.command.SVNLogCommand");
        ourCommands.put(new String[]{"switch", "sw"}, "org.tmatesoft.svn.cli.command.SVNSwitchCommand");
        ourCommands.put(new String[]{"diff", "di"}, "org.tmatesoft.svn.cli.command.SVNDiffCommand");
        ourCommands.put(new String[]{"merge"}, "org.tmatesoft.svn.cli.command.SVNMergeCommand");
        ourCommands.put(new String[]{"export"}, "org.tmatesoft.svn.cli.command.SVNExportCommand");
        ourCommands.put(new String[]{"cleanup"}, "org.tmatesoft.svn.cli.command.SVNCleanupCommand");
        ourCommands.put(new String[]{"lock"}, "org.tmatesoft.svn.cli.command.SVNLockCommand");
        ourCommands.put(new String[]{"unlock"}, "org.tmatesoft.svn.cli.command.SVNUnlockCommand");
        ourCommands.put(new String[]{"annotate", "blame", "praise", "ann"}, "org.tmatesoft.svn.cli.command.SVNAnnotateCommand");
        ourPegCommands = new HashSet();
        ourPegCommands.addAll(Arrays.asList("cat", "annotate", "checkout", "diff", "export", "info", "ls", "merge", "propget", "proplist", "log"));
        ourForceLogCommands = new HashSet();
        ourForceLogCommands.addAll(Arrays.asList("commit", "copy", "delete", "import", "mkdir", "move", "lock"));
    }
}

