/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.cert.X509Certificate;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil;

public class SVNConsoleAuthenticationProvider
implements ISVNAuthenticationProvider {
    public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
        if (!(certificate instanceof X509Certificate)) {
            return 1;
        }
        String hostName = url.getHost();
        X509Certificate cert = (X509Certificate)certificate;
        StringBuffer prompt = SVNSSLUtil.getServerCertificatePrompt((X509Certificate)cert, (String)realm, (String)hostName);
        if (resultMayBeStored) {
            prompt.append("\n(R)eject, accept (t)emporarily or accept (p)ermanently? ");
        } else {
            prompt.append("\n(R)eject or accept (t)emporarily? ");
        }
        System.out.print(prompt.toString());
        System.out.flush();
        int r = -1;
        try {
            char ch;
            do {
                if ((r = System.in.read()) < 0) {
                    return 0;
                }
                ch = (char)(r & 0xFF);
                if (ch == 'R' || ch == 'r') {
                    return 0;
                }
                if (ch != 't' && ch != 'T') continue;
                return 1;
            } while (!resultMayBeStored || ch != 'p' && ch != 'P');
            return 2;
        }
        catch (IOException e) {
            return 0;
        }
    }

    public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
        if ("svn.simple".equals(kind)) {
            String name = null;
            SVNConsoleAuthenticationProvider.printRealm(realm);
            while (name == null) {
                name = SVNConsoleAuthenticationProvider.prompt("Username");
                if (!"".equals(name)) continue;
                name = null;
            }
            String password = SVNConsoleAuthenticationProvider.prompt("Password for '" + name + "'");
            if (password == null) {
                password = "";
            }
            return new SVNPasswordAuthentication(name, password, authMayBeStored);
        }
        if ("svn.ssh".equals(kind)) {
            String name = null;
            SVNConsoleAuthenticationProvider.printRealm(realm);
            while (name == null) {
                name = SVNConsoleAuthenticationProvider.prompt("Username");
                if (!"".equals(name)) continue;
                name = null;
            }
            String password = SVNConsoleAuthenticationProvider.prompt("Password for '" + url.getHost() + "' (leave blank if you are going to use private key)");
            if ("".equals(password)) {
                password = null;
            }
            String keyFile = null;
            String passphrase = null;
            if (password == null) {
                while (keyFile == null) {
                    File file;
                    keyFile = SVNConsoleAuthenticationProvider.prompt("Private key for '" + url.getHost() + "' (OpenSSH format)");
                    if ("".equals(keyFile)) {
                        name = null;
                    }
                    if (!(file = new File(keyFile)).isFile() && !file.canRead() || !"".equals(passphrase = SVNConsoleAuthenticationProvider.prompt("Private key passphrase [none]"))) continue;
                    passphrase = null;
                }
            }
            int port = 22;
            String portValue = SVNConsoleAuthenticationProvider.prompt("Port number for '" + url.getHost() + "' [22]");
            if (portValue != null && !"".equals(portValue)) {
                try {
                    port = Integer.parseInt(portValue);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (password != null) {
                return new SVNSSHAuthentication(name, password, port, authMayBeStored);
            }
            if (keyFile != null) {
                return new SVNSSHAuthentication(name, new File(keyFile), passphrase, port, authMayBeStored);
            }
        } else {
            if ("svn.username".equals(kind)) {
                SVNConsoleAuthenticationProvider.printRealm(realm);
                String name = null;
                while (name == null) {
                    name = SVNConsoleAuthenticationProvider.prompt(!"file".equals(url.getProtocol()) ? "Author name [" + System.getProperty("user.name") + "]" : "Username [" + System.getProperty("user.name") + "]");
                    if (!"".equals(name) && name != null) continue;
                    name = System.getProperty("user.name");
                }
                return new SVNUserNameAuthentication(name, authMayBeStored);
            }
            if ("svn.ssl".equals(kind)) {
                SVNConsoleAuthenticationProvider.printRealm(realm);
                String path = null;
                while (path == null) {
                    path = SVNConsoleAuthenticationProvider.prompt("Client certificate filename");
                    if (!"".equals(path)) continue;
                    path = null;
                }
                String password = SVNConsoleAuthenticationProvider.prompt("Passphrase for '" + realm + "'");
                if (password == null) {
                    password = "";
                }
                return new SVNSSLAuthentication(new File(path), password, authMayBeStored);
            }
        }
        return null;
    }

    private static void printRealm(String realm) {
        if (realm != null) {
            System.out.println("Authentication realm: " + realm);
            System.out.flush();
        }
    }

    private static String prompt(String label) {
        System.out.print(label + ": ");
        System.out.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            return null;
        }
    }
}

