/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.command.SVNCommandEventProcessor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class SVNExportCommand
extends SVNCommand {
    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void run(PrintStream out, PrintStream err) throws SVNException {
        String path = this.getCommandLine().getPathAt(0);
        String url = null;
        if (this.getCommandLine().hasURLs()) {
            url = this.getCommandLine().getURL(0);
        }
        String srcPath = null;
        if (url == null) {
            srcPath = this.getCommandLine().getPathAt(0);
            path = this.getCommandLine().getPathAt(1);
        }
        SVNRevision revision = SVNExportCommand.parseRevision(this.getCommandLine());
        this.getClientManager().setEventHandler((ISVNEventHandler)new SVNCommandEventProcessor(out, err, false, true));
        SVNUpdateClient updater = this.getClientManager().getUpdateClient();
        String eol = (String)this.getCommandLine().getArgumentValue(SVNArgument.EOL_STYLE);
        if (url != null) {
            if (revision != SVNRevision.HEAD && revision.getDate() == null && revision.getNumber() < 0L) {
                revision = SVNRevision.HEAD;
            }
            updater.doExport(SVNURL.parseURIEncoded((String)url), new File(path).getAbsoluteFile(), revision, revision, eol, this.getCommandLine().hasArgument(SVNArgument.FORCE), !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE));
        } else if (srcPath != null) {
            if (revision == SVNRevision.UNDEFINED) {
                revision = SVNRevision.WORKING;
            }
            updater.doExport(new File(srcPath).getAbsoluteFile(), new File(path).getAbsoluteFile(), SVNRevision.UNDEFINED, revision, eol, this.getCommandLine().hasArgument(SVNArgument.FORCE), !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE));
        }
    }
}

