/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.ISVNInfoHandler;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.xml.SVNXMLInfoHandler;
import org.tmatesoft.svn.core.wc.xml.SVNXMLSerializer;
import org.xml.sax.ContentHandler;

public class SVNInfoCommand
extends SVNCommand
implements ISVNInfoHandler {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z (EE, d MMM yyyy)", Locale.getDefault());
    private PrintStream myOut;
    private File myBaseFile;

    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public final void run(PrintStream out, PrintStream err) throws SVNException {
        int i;
        boolean recursive = this.getCommandLine().hasArgument(SVNArgument.RECURSIVE);
        SVNRevision revision = SVNRevision.UNDEFINED;
        if (this.getCommandLine().hasArgument(SVNArgument.REVISION)) {
            revision = SVNRevision.parse((String)((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION)));
        }
        SVNWCClient wcClient = this.getClientManager().getWCClient();
        this.myOut = out;
        SVNXMLSerializer serializer = new SVNXMLSerializer((OutputStream)this.myOut);
        SVNXMLInfoHandler handler = new SVNXMLInfoHandler((ContentHandler)serializer);
        if (this.getCommandLine().hasArgument(SVNArgument.XML) && !this.getCommandLine().hasArgument(SVNArgument.INCREMENTAL)) {
            handler.startDocument();
        }
        Object infoHandler = this.getCommandLine().hasArgument(SVNArgument.XML) ? handler : this;
        for (i = 0; i < this.getCommandLine().getPathCount(); ++i) {
            this.myBaseFile = new File(this.getCommandLine().getPathAt(i));
            SVNRevision peg = this.getCommandLine().getPathPegRevision(i);
            handler.setTargetPath(this.myBaseFile);
            wcClient.doInfo(this.myBaseFile, peg, revision, recursive, (ISVNInfoHandler)infoHandler);
        }
        this.myBaseFile = null;
        for (i = 0; i < this.getCommandLine().getURLCount(); ++i) {
            String url = this.getCommandLine().getURL(i);
            SVNRevision peg = this.getCommandLine().getPegRevision(i);
            wcClient.doInfo(SVNURL.parseURIEncoded((String)url), peg, revision, recursive, (ISVNInfoHandler)infoHandler);
        }
        if (this.getCommandLine().hasArgument(SVNArgument.XML) && !this.getCommandLine().hasArgument(SVNArgument.INCREMENTAL)) {
            handler.endDocument();
        }
        if (this.getCommandLine().hasArgument(SVNArgument.XML)) {
            try {
                serializer.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private static void print(String str, PrintStream out) {
        out.println(str);
    }

    public void handleInfo(SVNInfo info) {
        if (!info.isRemote()) {
            SVNInfoCommand.print("Path: " + SVNFormatUtil.formatPath((File)info.getFile()), this.myOut);
        } else if (info.getPath() != null) {
            String path = info.getPath();
            if (this.myBaseFile != null) {
                File file = new File(this.myBaseFile, path);
                path = SVNFormatUtil.formatPath((File)file);
            } else {
                path = path.replace('/', File.separatorChar);
            }
            SVNInfoCommand.print("Path: " + path, this.myOut);
        }
        if (info.getKind() != SVNNodeKind.DIR) {
            if (info.isRemote()) {
                SVNInfoCommand.print("Name: " + SVNPathUtil.tail((String)info.getPath()), this.myOut);
            } else {
                SVNInfoCommand.print("Name: " + info.getFile().getName(), this.myOut);
            }
        }
        SVNInfoCommand.print("URL: " + info.getURL(), this.myOut);
        if (info.getRepositoryRootURL() != null) {
            SVNInfoCommand.print("Repository Root: " + info.getRepositoryRootURL(), this.myOut);
        }
        if (info.isRemote() && info.getRepositoryUUID() != null) {
            SVNInfoCommand.print("Repository UUID: " + info.getRepositoryUUID(), this.myOut);
        }
        if (info.getRevision() != null && info.getRevision().isValid()) {
            SVNInfoCommand.print("Revision: " + info.getRevision(), this.myOut);
        }
        if (info.getKind() == SVNNodeKind.DIR) {
            SVNInfoCommand.print("Node Kind: directory", this.myOut);
        } else if (info.getKind() == SVNNodeKind.FILE) {
            SVNInfoCommand.print("Node Kind: file", this.myOut);
        } else if (info.getKind() == SVNNodeKind.NONE) {
            SVNInfoCommand.print("Node Kind: none", this.myOut);
        } else {
            SVNInfoCommand.print("Node Kind: unknown", this.myOut);
        }
        if (info.getSchedule() == null && !info.isRemote()) {
            SVNInfoCommand.print("Schedule: normal", this.myOut);
        } else if (!info.isRemote()) {
            SVNInfoCommand.print("Schedule: " + info.getSchedule(), this.myOut);
        }
        if (info.getAuthor() != null) {
            SVNInfoCommand.print("Last Changed Author: " + info.getAuthor(), this.myOut);
        }
        if (info.getCommittedRevision() != null && info.getCommittedRevision().getNumber() >= 0L) {
            SVNInfoCommand.print("Last Changed Rev: " + info.getCommittedRevision(), this.myOut);
        }
        if (info.getCommittedDate() != null) {
            SVNInfoCommand.print("Last Changed Date: " + SVNInfoCommand.formatDate(info.getCommittedDate()), this.myOut);
        }
        if (!info.isRemote()) {
            if (info.getTextTime() != null) {
                SVNInfoCommand.print("Text Last Updated: " + SVNInfoCommand.formatDate(info.getTextTime()), this.myOut);
            }
            if (info.getPropTime() != null) {
                SVNInfoCommand.print("Properties Last Updated: " + SVNInfoCommand.formatDate(info.getPropTime()), this.myOut);
            }
            if (info.getChecksum() != null) {
                SVNInfoCommand.print("Checksum: " + info.getChecksum(), this.myOut);
            }
            if (info.getCopyFromURL() != null) {
                SVNInfoCommand.print("Copied From URL: " + info.getCopyFromURL(), this.myOut);
            }
            if (info.getCopyFromRevision() != null && info.getCopyFromRevision().getNumber() >= 0L) {
                SVNInfoCommand.print("Copied From Rev: " + info.getCopyFromRevision(), this.myOut);
            }
            if (info.getConflictOldFile() != null) {
                SVNInfoCommand.print("Conflict Previous Base File: " + info.getConflictOldFile().getName(), this.myOut);
            }
            if (info.getConflictWrkFile() != null) {
                SVNInfoCommand.print("Conflict Previous Working File: " + info.getConflictWrkFile().getName(), this.myOut);
            }
            if (info.getConflictNewFile() != null) {
                SVNInfoCommand.print("Conflict Current Base File: " + info.getConflictNewFile().getName(), this.myOut);
            }
            if (info.getPropConflictFile() != null) {
                SVNInfoCommand.print("Conflict Properties File: " + info.getPropConflictFile().getName(), this.myOut);
            }
        }
        if (info.getLock() != null) {
            SVNLock lock = info.getLock();
            SVNInfoCommand.print("Lock Token: " + lock.getID(), this.myOut);
            SVNInfoCommand.print("Lock Owner: " + lock.getOwner(), this.myOut);
            SVNInfoCommand.print("Lock Created: " + SVNInfoCommand.formatDate(lock.getCreationDate()), this.myOut);
            if (lock.getComment() != null) {
                this.myOut.print("Lock Comment ");
                int lineCount = SVNInfoCommand.getLinesCount(lock.getComment());
                if (lineCount == 1) {
                    this.myOut.print("(1 line)");
                } else {
                    this.myOut.print("(" + lineCount + " lines)");
                }
                this.myOut.print(":\n" + lock.getComment() + "\n");
            }
        }
        SVNInfoCommand.println(this.myOut);
    }

    private static String formatDate(Date date) {
        return DATE_FORMAT.format(date);
    }
}

