/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.ISVNChangeEntryHandler;
import org.tmatesoft.svn.core.wc.admin.SVNChangeEntry;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;

public class SVNLookChangedCommand
extends SVNCommand
implements ISVNChangeEntryHandler {
    private PrintStream myOut;

    public void run(PrintStream out, PrintStream err) throws SVNException {
        if (!this.getCommandLine().hasPaths()) {
            SVNCommand.println(err, "jsvnlook: Repository argument required");
            System.exit(1);
        }
        File reposRoot = new File(this.getCommandLine().getPathAt(0));
        this.myOut = out;
        SVNRevision revision = SVNRevision.HEAD;
        SVNLookClient lookClient = this.getClientManager().getLookClient();
        boolean isCopyInfoIncluded = this.getCommandLine().hasArgument(SVNArgument.COPY_INFO);
        if (this.getCommandLine().hasArgument(SVNArgument.TRANSACTION)) {
            String transactionName = (String)this.getCommandLine().getArgumentValue(SVNArgument.TRANSACTION);
            lookClient.doGetChanged(reposRoot, transactionName, (ISVNChangeEntryHandler)this, isCopyInfoIncluded);
            return;
        }
        if (this.getCommandLine().hasArgument(SVNArgument.REVISION)) {
            revision = SVNRevision.parse((String)((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION)));
        }
        lookClient.doGetChanged(reposRoot, revision, (ISVNChangeEntryHandler)this, isCopyInfoIncluded);
    }

    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void handleEntry(SVNChangeEntry entry) throws SVNException {
        String[] status = new String[]{entry.getType() == 'U' && !entry.hasTextModifications() ? "_" : "" + entry.getType(), entry.hasPropertyModifications() ? "U" : " ", entry.getCopyFromPath() != null ? "+" : " "};
        String path = !entry.getPath().endsWith("/") && entry.getKind() == SVNNodeKind.DIR ? entry.getPath() + "/" : entry.getPath();
        path = path.startsWith("/") ? path.substring(1) : path;
        SVNCommand.println(this.myOut, status[0] + status[1] + status[2] + " " + path);
        if (entry.getCopyFromPath() != null) {
            String copyFromPath = entry.getCopyFromPath();
            if (copyFromPath.startsWith("/")) {
                copyFromPath = copyFromPath.substring(1);
            }
            if (!copyFromPath.endsWith("/") && entry.getKind() == SVNNodeKind.DIR) {
                copyFromPath = copyFromPath + "/";
            }
            SVNCommand.println(this.myOut, "    (from " + copyFromPath + ":r" + entry.getCopyFromRevision() + ")");
        }
    }
}

