/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.command.SVNLookDateCommand;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;

public class SVNLookInfoCommand
extends SVNCommand {
    public void run(PrintStream out, PrintStream err) throws SVNException {
        if (!this.getCommandLine().hasPaths()) {
            SVNCommand.println(err, "jsvnlook: Repository argument required");
            System.exit(1);
        }
        File reposRoot = new File(this.getCommandLine().getPathAt(0));
        SVNRevision revision = SVNRevision.HEAD;
        SVNLookClient lookClient = this.getClientManager().getLookClient();
        if (this.getCommandLine().hasArgument(SVNArgument.TRANSACTION)) {
            String transactionName = (String)this.getCommandLine().getArgumentValue(SVNArgument.TRANSACTION);
            SVNLogEntry entry = lookClient.doGetInfo(reposRoot, transactionName);
            this.printInfo(entry, out);
            return;
        }
        if (this.getCommandLine().hasArgument(SVNArgument.REVISION)) {
            revision = SVNRevision.parse((String)((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION)));
        }
        SVNLogEntry entry = lookClient.doGetInfo(reposRoot, revision);
        this.printInfo(entry, out);
    }

    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    private void printInfo(SVNLogEntry entry, PrintStream out) {
        String author = entry.getAuthor() != null ? entry.getAuthor() : "";
        String date = entry.getDate() != null ? SVNLookDateCommand.formatDate(entry.getDate()) : "";
        String log = entry.getMessage() != null ? entry.getMessage() : "";
        SVNCommand.println(out, author);
        SVNCommand.println(out, date);
        if (log == null || log.length() == 0) {
            SVNCommand.println(out, "0");
        } else {
            SVNCommand.println(out, String.valueOf(log.length()));
            SVNCommand.println(out, log);
        }
    }
}

